% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getEuropeReferenceTable}
\alias{getEuropeReferenceTable}
\alias{getEuropeCountries}
\alias{getEuropeStates}
\alias{spMaps}
\alias{getSpMaps}
\title{Get custom Europe map (\code{SpatialPolygonsDataFrame})}
\usage{
getEuropeReferenceTable()

getEuropeCountries()

getEuropeStates()

getSpMaps(countries = "all", states = NULL)
}
\arguments{
\item{countries}{\code{character}. Vector of wanted countries, without details / states.
Must referred to \code{code} column of the reference table \code{getEuropeReferenceTable}.
"all" (default) keep all countries}

\item{states}{\code{character}. Vector of wanted countries, with details / states.
Must referred to \code{code} column of the reference table \code{getEuropeReferenceTable}.
"all" keep all countries. NULL as default.}
}
\value{
\code{SpatialPolygonsDataFrame}
}
\description{
This function builds a custom Europe map and return a \code{SpatialPolygonsDataFrame}.
The output can be use by example in \link[antaresViz]{mapLayout} with the \code{map} argument.
}
\examples{

# default map : Europe without states
europe_cty <- getSpMaps()
plot(europe_cty)

# subset on some countries
ref_table <- getEuropeReferenceTable()

italy_spain_fra <- getSpMaps(countries = c("FRA", "ITA", "ESP"))
plot(italy_spain_fra)

\dontrun{
italy_spain_fra_states <- getSpMaps(countries = NULL, states = c("FRA", "ITA", "ESP"))
plot(italy_spain_fra_states)

# combine countries and states
combine_map <- getSpMaps(countries = c("ITA", "ESP"), states = "FRA")
plot(combine_map)

# build your custom map : you can use directly data
# to subset the area you really want
europe_states <- getEuropeStates()
europe_countries <- getEuropeCountries()

# for example, have a look to GBR states map
summary(europe_states)
gbr_states_districts <- europe_states[
   europe_states$sr_adm0_a3 \%in\% "GBR" &
   europe_states$type \%in\% "Administrative County",]
plot(gbr_states_districts)

# combine with another map : you just have to have the same columns...
# getSpMaps only return "name" column
custom_states <- rbind(
    getSpMaps(countries = NULL, states = "FRA"),
    gbr_states_districts[, "name", drop = FALSE])

plot(custom_states)

}

}
