% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{network_knn.mc}
\alias{network_knn.mc}
\title{K-nearest points on network (multicore version)}
\usage{
network_knn.mc(
  origins,
  lines,
  k,
  destinations = NULL,
  maxdistance = 0,
  snap_dist = Inf,
  line_weight = "length",
  direction = NULL,
  grid_shape = c(1, 1),
  verbose = FALSE,
  digits = 3,
  tol = 0.1
)
}
\arguments{
\item{origins}{A SpatialPointsDataFrame, for each point, its k nearest
neighbours will be found on the network.}

\item{lines}{A SpatialLinesDataFrame representing the underlying network}

\item{k}{An integer indicating the number of neighbours to find.}

\item{destinations}{A SpatialPointsDataFrame, might be used if the neighbours
must be found in a separate set of points NULL if the neighbours must be found in
origins.}

\item{maxdistance}{The maximum distance between two observations to
consider them as neighbours. It is useful only if a grid is used, a
lower value will reduce calculating time, but one must be sure that the
k nearest neighbours are within this radius. Otherwise NAs will be present
in the results.}

\item{snap_dist}{The maximum distance to snap the start and end points on
the network.}

\item{line_weight}{The weighting to use for lines. Default is "length"
(the geographical length), but can be the name of a column. The value is
considered proportional to the geographical length of the lines.}

\item{direction}{The name of a column indicating authorized
traveling direction on lines. if NULL, then all lines can be used in both
directions. Must be the name of a column otherwise. The values of the
column must be "FT" (From - To), "TF" (To - From) or "Both".}

\item{grid_shape}{A vector of length 2 indicating the shape of the grid to
use for splitting the dataset. Default is c(1,1), so all the calculation is
done in one go. It might be necessary to split it if the dataset is large.}

\item{verbose}{A Boolean indicating if the function should print its
progress}

\item{digits}{The number of digits to retain from the spatial coordinates (
simplification used to reduce risk of topological error)}

\item{tol}{A float indicating the minimum distance between the points and the
lines' extremities when adding the point to the network. When points are
closer, they are added at the extremity of the lines.}
}
\value{
A list with two matrices, one with the index of the neighbours and
one with the distances.
}
\description{
Calculate the K-nearest points for a set of points on a network with multicore support.
}
\examples{
\donttest{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
main_network_mtl <- rgdal::readOGR(networkgpkg,layer="main_network_mtl", verbose=FALSE)
mtl_libraries <- rgdal::readOGR(eventsgpkg,layer="mtl_libraries", verbose=FALSE)
future::plan(future::multisession(workers=2))
results <- network_knn.mc(mtl_libraries, main_network_mtl,
    k = 3, maxdistance = 1000, line_weight = "length",
    grid_shape=c(1,1), verbose = FALSE)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
