% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporal_kde_sf.R
\name{tkde}
\alias{tkde}
\title{Temporal Kernel density estimate}
\usage{
tkde(events, w, samples, bw, kernel_name, adaptive = FALSE)
}
\arguments{
\item{events}{A numeric vector representing the moments of occurrence of events}

\item{w}{The weight of the events}

\item{samples}{A numeric vector representing the moments to sample}

\item{bw}{A float, the bandwidth to use}

\item{kernel_name}{The name of the kernel to use}

\item{adaptive}{Boolean}
}
\value{
A numeric vector with the density values at the requested timestamps
}
\description{
Calculate the Temporal kernel density estimate based on sampling points in
time and events
}
\examples{
data(bike_accidents)
bike_accidents$Date <- as.POSIXct(bike_accidents$Date, format = "\%Y/\%m/\%d")
start <- min(bike_accidents$Date)
diff <- as.integer(difftime(bike_accidents$Date , start, units = "days"))
density <- tkde(diff, rep(1,length(diff)), seq(0,max(diff),1), 2, "quartic")
}
