# LMatrix assumed to be dense
.get_invL_HLfit <- function(object, regul.threshold=1e-7) { ## computes inv(L) [not inv(Corr): see calc_invColdoldList]
  strucList <- object$strucList
  if (is.null(strucList)) {
    return(NULL) ## no ranefs
  } else if (is.null(unlist(strucList))) { ## ranefs with trivial strucList
    if (is.null(object$envir$invL)) {
      cum_n_u_h <- attr(object$lambda,"cum_n_u_h")
      object$envir$invL <- Diagonal(n=cum_n_u_h[length(cum_n_u_h)])
    }
    return(object$envir$invL)
  } else {
    if (is.null(object$envir$invL)) {
      cum_n_u_h <- attr(object$lambda,"cum_n_u_h")
      resu <- diag(cum_n_u_h[length(cum_n_u_h)])
      if (object$spaMM.version < "2.2.116") {
        ranefs <- attr(object$ZAlist,"ranefs") 
      } else ranefs <- attr(object$ZAlist,"exp_ranef_strings") 
      for (Lit in seq_len(length(strucList))) {
        lmatrix <- strucList[[Lit]]
        if ( ! is.null(lmatrix)) {
          type <-  attr(lmatrix,"type")
          invlmatrix <- NULL
          if ( ! is.null(latentL_blob <- attr(lmatrix,"latentL_blob"))) { ## from .process_ranCoefs
            compactchol_Q <- latentL_blob$compactchol_Q 
            if (is.null(compactchol_Q)) {
              invlmatrix <- .makelong(solve(latentL_blob$design_u),longsize=ncol(lmatrix),as_matrix=TRUE)
            } else invlmatrix <- .makelong(t(compactchol_Q),longsize=ncol(lmatrix),as_matrix=TRUE) ## L=Q^{-T} => invL=Q^T
            # as_matrix necessary for resu[u.range, u.range] <- invlmatrix
          } else if (type == "from_AR1_specific_code")  {
            invlmatrix <- solve(lmatrix) # cost of solve sparse triangular matrix
            invlmatrix <- as.matrix(invlmatrix) ## for [<-.matrix
          } else if (type == "from_Q_CHMfactor")  {
            invlmatrix <- t(as(attr(lmatrix,"Q_CHMfactor"),"sparseMatrix")) ## L=Q^{-T} => invL=Q^T ## correct but requires the attribute => numerical issues in computing Q_CHMfactor
            invlmatrix <- as.matrix(invlmatrix) ## for [<-.matrix
          } else if (type == "cholL_LLt")  {
            condnum <- kappa(lmatrix,norm="1")
            if (condnum<1/regul.threshold) {
              invlmatrix <- try(forwardsolve(lmatrix,diag(ncol(lmatrix))),silent=TRUE)
              if (inherits(invlmatrix,"try-error")) invlmatrix <- NULL
            }
            if (is.null(invlmatrix)) Rmatrix <- t(lmatrix)
          } else { ## Rcpp's symSVD, or R's eigen() => LDL (also possible bad use of R's svd, not normally used)
            condnum <- kappa(lmatrix,norm="1")
            if (condnum<1/regul.threshold) {
              decomp <- attr(lmatrix,attr(lmatrix,"type")) ## of corr matrix !
              if ( all(abs(decomp$d) > regul.threshold) ) {
                invlmatrix <-  try(.ZWZt(decomp$u,sqrt(1/decomp$d)),silent=TRUE) ## try() still allowing for no (0) regul.threshold; not useful ?
                if (inherits(invlmatrix,"try-error")) invlmatrix <- NULL
              }
            }
            if (is.null(invlmatrix)) Rmatrix <- qr.R(qr(t(lmatrix))) 
          }
          if (is.null(invlmatrix)){
            # chol2inv is quite robust in the sense of not stopping, even without any regularization.
            # Nevertheless (1) lmatrix %*% invlmatrix may be only roughly = I:
            #   if we don't regularize we expect departures from I due to numerical precision;
            #   if we regularize we expect departures from I even with exact arithmetic...
            #
            # But regul. chol2inv result still causes problems in later computations!
            #
            # singular <- which(abs(diag(Rmatrix))<regul.threshold) 
            # if (length(singular)) {
            #   if (spaMM.getOption("wRegularization")) warning("regularization required.")
            #   nc <- ncol(Rmatrix)
            #   diagPos <- seq.int(1L,nc^2,nc+1L)[singular]
            #   Rmatrix[diagPos] <- sign(Rmatrix[diagPos])* regul.threshold
            # }
            # invLLt <- chol2inv(Rmatrix) ## 
            #
            invLLt <- try(chol2inv(Rmatrix),silent=TRUE)
            if (inherits(invLLt,"try-error") || max(abs(range(invLLt)))> 1e12) {
              invLLt <- ginv(crossprod(Rmatrix))
            }
            invlmatrix <- .crossprod(lmatrix, invLLt) ## regularized (or not) solve(lmatrix)
          }
          u.range <- (cum_n_u_h[Lit]+1L):(cum_n_u_h[Lit+1L])
          resu[u.range,u.range] <- invlmatrix   
        }
      }
      object$envir$invL <- resu
    }
    return(object$envir$invL)
  }
}




## fitted= X.beta + ZLv where we want to be able to write Lv as Cw = L.L'.w 
# => w = inv(L').v
.calc_invL_coeffs <- function(object,newcoeffs) { ##replaces dv/dloglan  by dw/dloglam
  strucList <- object$strucList
  if ( ! is.null(strucList)) {
    cum_n_u_h <- attr(object$lambda,"cum_n_u_h") ## FIXME: avoid using object$lambda
    for (Lit in seq_len(length(strucList))) {
      lmatrix <- strucList[[Lit]]
      if (! is.null(lmatrix)) { ## spatial or random-coef
        u.range <- (cum_n_u_h[Lit]+1L):(cum_n_u_h[Lit+1L])
        ## dense calculation on not necess triangular lmatrix (!?). 
        ## solve( _t_(lmatrix)) may not allow the efficient use of solveWrap. 
        ## But this is a one-time calculation whose results are saved. No optimization attempted.
        newcoeffs[u.range] <- solve(t(lmatrix),newcoeffs[u.range])   ## newcoeffs must be a _vector_
      }
    }
  }
  return(newcoeffs)
}


.getHLfit <- function(fitobject) {
  if (inherits(fitobject,"HLfit")) {
    fitobject    
  } else if (inherits(fitobject,"HLCor")) {
    fitobject$hlfit    
  } else if (inherits(fitobject,"corrHLfit")) {
    fitobject$hlfit    
  }
} 

fitted.HLfit <- function(object,...) {
  object <- .getHLfit(object)
  object$fv
}

.get_BinomialDen <- function(object) {
  if (object$spaMM.version<"2.0.17") {
    return(object$weights)
  } else return(object$BinomialDen)
}

residuals.HLfit <- function(object, type = c("deviance", "pearson", "response"), ...) {
  object <- .getHLfit(object)
  type <- match.arg(type)
  BinomialDen <- .get_BinomialDen(object) 
  if (is.null(BinomialDen)) BinomialDen <- 1L
  y <- object$y / BinomialDen ## le y 
  mu <- object$fv # on 0-1 probability scale for binomial models
  wts <- object$prior.weights * BinomialDen ## the BinomialDen are in the $prior.weights of a glm object, but not of an HLfit one
  res <- switch(type, deviance = #if (object$df.residual > 0) 
                  { d.res <- sqrt(pmax((object$family$dev.resids)(y, mu, 
                                                  wts), 0))
    ifelse(y > mu, d.res, -d.res)
  } #else rep.int(0, length(mu))
  , pearson = (y - mu) * sqrt(wts)/sqrt(object$family$variance(mu)), 
  response = y - mu)
  #if (!is.null(object$na.action))  res <- naresid(object$na.action, res)
  res
}

ranef.HLfit <- function(object,type="correlated",...) {
  object <- .getHLfit(object)
  lambda.object <- object$lambda.object
  print_namesTerms <- lambda.object$print_namesTerms
  repGroupNames <- unlist(lapply(seq_len(length(print_namesTerms)), function(it) {
    names(print_namesTerms[[it]]) <- rep(names(print_namesTerms)[it],length(print_namesTerms[[it]]))
  })) ## makes group identifiers unique (names of coeffs are unchanged)
  if (type=="correlated") {
    uv_h <- object$v_h 
  } else uv_h <- object$ranef #random effects \eqn{u}
  cum_n_u_h <- attr(object$ranef,"cum_n_u_h")
  if (object$spaMM.version < "2.2.116") {
    ranefs <- attr(object$ZAlist,"ranefs") 
  } else ranefs <- attr(object$ZAlist,"exp_ranef_strings") 
  #colNames <- lapply(object$ZAlist,"colnames") without a slow lapply():
  colNames <- vector("list", length(object$ZAlist))
  names(colNames) <- names(object$ZAlist)
  for (it in seq_along(object$ZAlist)) colNames[[it]] <- colnames(object$ZAlist[[it]])
  # compute Lv from v:
  strucList <- object$strucList
  RESU <- vector("list", length(ranefs))
  for (it in seq_along(ranefs)) {
    u.range <- (cum_n_u_h[it]+1L):(cum_n_u_h[it+1L])
    res <- uv_h[u.range] # vector
    if ((nr <- length(print_namesTerms[[it]]))>1L) { # random-coef term
      n_cols <- length(colNames[[it]])/length(print_namesTerms[[it]])
      if (type == "correlated") {
        res <- strucList[[it]] %*% res ## matrix
        res <- structure(matrix(res, ncol=n_cols,byrow=TRUE), dimnames=list(print_namesTerms[[it]],colNames[[it]][1:n_cols]))
        res <- t(res) # despite the t() it makes it ~ to the vector in the alternative case (both operate as n_u_h-row matrices) 
      } else {
        res <- structure(matrix(res, ncol=n_cols,byrow=TRUE), dimnames= list(NULL, colNames[[it]][1:n_cols])) ## matrix
      }
    } else {
      if (type == "correlated" && ! is.null(strucList[[it]])) {
        res <- as.vector(strucList[[it]] %*% res) ## vector
      } 
      names(res) <- colNames[[it]]
    }
    RESU[[it]] <- res
  }
  names(RESU) <- ranefs
  class(RESU) <- c("list","ranef")
  RESU ## TODO: ~lme4:::ranef.merMod(mod, condVar = TRUE) & ajouter des arguments "variances" et "intervals" à ta fonction ranef() (Alex 7/5/2018)
}

print.ranef <- function(x, max.print=40L, ...) {
  oldopt <- options(max.print=max.print)
  print.default(x)
  options(oldopt)
}

fixef.HLfit <- function(object,...) {
  object <- .getHLfit(object)
  object$fixef    
}

logLik.HLfit <- function(object, which=NULL, ...) {
  object <- .getHLfit(object)
  if (is.null(which)) {
    mess <- .REMLmess(object)
    which <- switch(mess, 
                    "by stochastic EM."= "logLapp",
                    "by Laplace ML approximation (p_v)."= "p_v",
                    "by h-likelihood approximation."= "p_v",
                    "by ML."= "p_v",
                    "by Laplace REML approximation (p_bv)."= "p_bv",
                    "by REML."= "p_bv",
                    "by non-standard REML"= "p_bv",
                    stop(paste0("No default '",which,"' value for '",mess,"' estimation method."))
                    ) 
  }
  resu  <- object$APHLs[[which]]
  names(resu) <- which
  return(resu)
}

vcov.HLfit <- function(object,...) {
  object <- .getHLfit(object)
  beta_cov <- .get_beta_cov_any_version(object)
  class(beta_cov) <- c("vcov.HLfit",class(beta_cov))
  return(beta_cov)
}

.get_beta_cov_any_version <- function(object) {
  beta_cov <- object$beta_cov ## set by HLfit using get_from_MME(, which="beta_cov")
  if (is.null(beta_cov)) { ## should never happen
    return(.get_beta_cov_info(object))
  } else return(beta_cov)
}

# addition post 1.4.4
Corr <- function(object,...) { ## compare ?VarCorr
  trivial <- "No non-trivial correlation matrix for this random effect"
  strucList <- object$strucList
  locfn <- function(it) {
    resu <- object$cov.mats[[it]]
    if (is.null(resu)) resu <- .tcrossprod(strucList[[it]],NULL)
    if (is.null(resu)) resu <- trivial 
    return(resu) ## may still be NULL
  }
  if ( ! is.null(strucList)) {
    resu <- lapply(seq_len(length(strucList)), locfn) ## list for the different ranefs   
  } else {
    message(trivial)
    resu <- list(`1`=trivial) 
  }
  return(resu)
}

dev_resids <- function(object,...) {
  mu <- predict(object)
  BinomialDen <- .get_BinomialDen(object) 
  if (is.null(BinomialDen)) BinomialDen <- 1
  object$family$dev.resids(object$y/BinomialDen,mu,BinomialDen)
}

deviance.HLfit <- function(object,...) {
  dev_res2 <- dev_resids(object=object,...)
  return(sum(dev_res2))
}  

get_fixefVar <- function(...) {
  mc <- match.call(expand.dots = TRUE)
  mc$variances$fixefVar <- TRUE
  mc[[1L]] <- get("predict.HLfit", asNamespace("spaMM")) ## https://stackoverflow.com/questions/10022436/do-call-in-combination-with
  attr(eval(mc,parent.frame()),"fixefVar")
}

get_predVar <- function(...) {
  mc <- match.call(expand.dots = TRUE)
  mc$variances$predVar <- TRUE
  mc[[1L]] <- get("predict.HLfit", asNamespace("spaMM")) ## https://stackoverflow.com/questions/10022436/do-call-in-combination-with
  attr(eval(mc,parent.frame()),"predVar")
}

get_residVar <- function(...) {
  mc <- match.call(expand.dots = TRUE)
  mc$variances$residVar <- TRUE
  mc[[1L]] <- get("predict.HLfit", asNamespace("spaMM")) ## https://stackoverflow.com/questions/10022436/do-call-in-combination-with
  attr(eval(mc,parent.frame()),"residVar")
}

get_respVar <- function(...) {
  mc <- match.call(expand.dots = TRUE)
  mc$variances$respVar <- TRUE
  mc[[1L]] <- get("predict.HLfit", asNamespace("spaMM")) ## https://stackoverflow.com/questions/10022436/do-call-in-combination-with
  attr(eval(mc,parent.frame()),"respVar")
}

get_intervals <- function(...) {
  mc <- match.call(expand.dots = TRUE)
  mc[[1L]] <- get("predict.HLfit", asNamespace("spaMM")) ## https://stackoverflow.com/questions/10022436/do-call-in-combination-with
  if (is.null(mc$intervals)) mc$intervals <- "respVar"
  attr(eval(mc,parent.frame()),"intervals") ## intervals by gaussian approx (possibly student'), not LR 
}


get_RLRTSim_args <- function(object,...) {
  if (object$family$family !="gaussian" 
      || (object$models[["eta"]]=="etaHGLM" && any(attr(object$rand.families,"lcrandfamfam")!="gaussian"))) {
    warning("'object' is not the fit of a LMM, while RLRTSim() methods were conceived for LMMs.")
  }
  X.pv <- as.matrix(object$X.pv)
  qrX.pv <- qr(X.pv)
  ZAL <- get_ZALMatrix(object)
  if(inherits(ZAL,"Matrix")) ZAL <- as.matrix(ZAL)
  sqrt.s <- diag(ncol(ZAL))
  return(list(X=X.pv, Z=ZAL, qrX = qrX.pv, sqrt.Sigma=sqrt.s))
}
# get_dispVar : dispVar in not a returned attribute

get_rankinfo <- function(object) return(attr(object$X.pv,"rankinfo")) 

get_ranPars <- function(object, which=NULL, ...) {
  CorrEst_and_RanFix <- object$CorrEst_and_RanFix
  if (is.null(which)) {
    return(CorrEst_and_RanFix)
  } else if (which=="corrPars") {
    resu <- CorrEst_and_RanFix$corrPars
    if ( ! is.null(resu)) resu <- structure(resu, type=attr(CorrEst_and_RanFix,"type")$corrPars)
    return(resu)
  } else if (which=="lambda") {
    resu <- CorrEst_and_RanFix$lambda
    if ( ! is.null(resu)) resu <- structure(resu, type=attr(CorrEst_and_RanFix,"type")$lambda)
    return(resu)
  } 
}

.get_sub_corr_info <- function(object) {
  if (is.null(object$sub_corr_info)) {
    return(object$corr_info) ## occurs for < v2.4.57
  } else return(object$sub_corr_info)
}

formula.HLfit <- function(x, ...) {
  if (x$spaMM.version> "2.4.35") {
    form <- x$call$formula
  } else form <- getCall.HLfit(x)$formula
  if (is.null(form)) { 
    ## residual fit has no explicit call of its own. Do not try to access or even create $call$resid.model$formula as was done in version < 2.4.136
    ##   or
    ## HLfit member object in an HLfitlist  ( F I X M E : they have a call with $processed and no $formula 
    ##          bc it's not clear where to get a non-processed HLCor or HLfit call if the oricall was an outer optimizing fn)
    #    or    
    ## should not occur on a finished HLfit object but may on a call with $processed accessed in a debugging session
    ## stats:::formula.default looks for x$formula then x$call$formula (so ultimately formula(object) should be enough ?)
    #  If it finds neither (no explicitly named formula in the call), it evaluates the call, which leads to an infinite recursion
    # since form is then an HLfit object so print(form...) will call summary.HLfit()...
    form <- x$predictor
  }
  form
} ## stats::formula generic

terms.HLfit <- function(x, ...) { ## the full formula with the attributes for the fixed effects only (OK for MSFDR -> stats::step())
  # distinct attributes for ranefs wold surely work.
  form <- x$predictor
  attributes(form) <- attributes(x$HLframes$fixef_terms)
  return(form)
}

nobs.HLfit <- function(object, ...) {length(object$y)}

get_any_IC <- function(object,...,verbose=interactive(),also_cAIC=TRUE) {
  info_crits <- .get_info_crits(object,also_cAIC=also_cAIC)
  likelihoods <- numeric(0)
  if (!is.null(info_crits$mAIC))  likelihoods <- c(likelihoods,"       marginal AIC:"=info_crits$mAIC)
  if (!is.null(info_crits$cAIC))  likelihoods <- c(likelihoods,"    conditional AIC:"=info_crits$cAIC)
  if (!is.null(info_crits$dAIC))  likelihoods <- c(likelihoods,"     dispersion AIC:"=info_crits$dAIC)
  if (!is.null(info_crits$GoFdf)) likelihoods <- c(likelihoods,"       effective df:"=info_crits$GoFdf)
  if (verbose) {
    astable <- as.matrix(likelihoods)
    write.table(format(astable, justify="right"), col.names=FALSE, quote=FALSE) 
  }
  invisible(likelihoods)
}

AIC.HLfit <- function(object, ..., k,verbose=interactive(),also_cAIC=TRUE) {
  get_any_IC(object,...,verbose=verbose,also_cAIC=also_cAIC)
}

extractAIC.HLfit <- function(fit, scale, k=2L, ..., verbose=FALSE) { ## stats::extractAIC generic
  df <- fit$dfs[["pforpv"]]
  aic <- AIC(object=fit, ..., verbose = verbose,also_AIC=FALSE)[["       marginal AIC:"]] # does not use k
  if (k !=2L) aic <- aic + (k - 2)*df
  c(edf=df, AIC=aic) 
}

model.matrix.HLfit <- function(object, ...) object$X.pv

"how" <- function(object, ...) UseMethod("how")

how.default <- function(object, ...) {message(paste("No 'how' method defined for objects of class",class(object)))} 

how.HLfit <- function(object, devel=FALSE, ...) {
  info <- object$how
  if (is.null(info)) {
    info <- list(MME_method=setdiff(object$MME_method,c("list")),
                 fit_time=object$fit_time,
                 "spaMM.version"=object$spaMM.version)
  }
  if  ( is.null(resid_fit <- object$resid_fit)) {
    print(paste0("Model fitted by spaMM, version ",info[["spaMM.version"]],
                 ", in ",info$fit_time,"s using method: ",paste(info$MME_method,collapse=","),"."))
  } else {
    print(paste0("Model fitted by spaMM, version ",info[["spaMM.version"]],
                 ", in ",info$fit_time,"s using method: ",paste(info$MME_method,collapse=","),"."))
    #
    resid_info <- object$resid_fit$how
    if (is.null(resid_info)) {
      resid_info <- list( MME_method=setdiff(object$resid_fit$MME_method,c("list")) )
    }
    print(paste0("Residual model fitted using method: ",paste(resid_info$MME_method, collapse=","),"."))
    info$resid_info <- resid_info
  }
  if (devel && ! is.null(switches <- info$switches)) {
    print(paste(paste(names(switches),"=",switches), collapse = ", "))
    
  }
  invisible(info)
}


