% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{match_lineshape}
\alias{match_lineshape}
\title{Apply Voigt line-broadening to match a reference spectrum.}
\usage{
match_lineshape(
  mrs_data,
  ref,
  xlim,
  init_lb = 0.2,
  init_lg = 0.5,
  init_amp = 1,
  min_lb = 0,
  max_lb = Inf,
  min_lg = 0,
  max_lg = 1,
  min_amp = 0.1,
  max_amp = 2,
  amp_optim = TRUE
)
}
\arguments{
\item{mrs_data}{data to be broadened, note the linewidth of this spectrum
must be narrower than the ref spectrum.}

\item{ref}{reference data to match.}

\item{xlim}{spectral region to match, eg c(5.2, 4.1) could be used to match
two water resonances.}

\item{init_lb}{initial value for the amount of line-broadening to apply (Hz).}

\item{init_lg}{initial value for the Lorentz-Gauss lineshape parameter.}

\item{init_amp}{initial value for the amplitude parameter.}

\item{min_lb}{minimum value for the amount of line-broadening to apply (Hz).}

\item{max_lb}{maximum value for the amount of line-broadening to apply (Hz).}

\item{min_lg}{minimum value for the Lorentz-Gauss lineshape parameter.}

\item{max_lg}{maximum value for the Lorentz-Gauss lineshape parameter.}

\item{min_amp}{minimum value for the amplitude parameter.}

\item{max_amp}{maximum value for the amplitude parameter.}

\item{amp_optim}{flag to include amplitude adjustment in the optimisation
procedure. Defaults to TRUE.}
}
\value{
a list containing the matched mrs_data, difference spectra and
optimisation results.
}
\description{
Apply Voigt line-broadening to match a reference spectrum.
}
