% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_parquet}
\alias{spark_write_parquet}
\title{Write a Spark DataFrame to a Parquet file}
\usage{
spark_write_parquet(x, path, mode = NULL, options = list())
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3n://"} and \samp{"file://"} protocols.}

\item{mode}{Specifies the behavior when data or table already exists.}

\item{options}{A list of strings with additional options. See \url{http://spark.apache.org/docs/latest/sql-programming-guide.html#configuration}.}
}
\description{
Serialize a Spark DataFrame to the
\href{https://parquet.apache.org/}{Parquet} format.
}
\seealso{
Other Spark serialization routines: \code{\link{spark_load_table}},
  \code{\link{spark_read_csv}},
  \code{\link{spark_read_json}},
  \code{\link{spark_read_parquet}},
  \code{\link{spark_save_table}},
  \code{\link{spark_write_csv}},
  \code{\link{spark_write_json}}
}

