/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.input.DefaultCharAppender;
import java.io.IOException;
import java.io.Writer;

public class WriterCharAppender
extends DefaultCharAppender {
    private final char lineSeparator1;
    private final char lineSeparator2;
    private final char newLine;

    public WriterCharAppender(int maxLength, String emptyValue, Format format) {
        this(maxLength, emptyValue, ' ', format);
    }

    public WriterCharAppender(int maxLength, String emptyValue, char padding, Format format) {
        super(maxLength, emptyValue, padding);
        char[] lineSeparator = format.getLineSeparator();
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length > 1 ? lineSeparator[1] : (char)'\u0000';
        this.newLine = format.getNormalizedNewline();
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        if (ch == this.newLine) {
            super.appendIgnoringWhitespace(this.lineSeparator1);
            if (this.lineSeparator2 != '\u0000') {
                super.appendIgnoringWhitespace(this.lineSeparator2);
            }
        } else {
            super.appendIgnoringWhitespace(ch);
        }
    }

    @Override
    public void appendIgnoringPadding(char ch) {
        if (ch == this.newLine) {
            super.appendIgnoringPadding(this.lineSeparator1);
            if (this.lineSeparator2 != '\u0000') {
                super.appendIgnoringPadding(this.lineSeparator2);
            }
        } else {
            super.appendIgnoringPadding(ch);
        }
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch) {
        if (ch == this.newLine) {
            super.appendIgnoringWhitespaceAndPadding(this.lineSeparator1);
            if (this.lineSeparator2 != '\u0000') {
                super.appendIgnoringWhitespaceAndPadding(this.lineSeparator2);
            }
        } else {
            super.appendIgnoringWhitespaceAndPadding(ch);
        }
    }

    @Override
    public void append(char ch) {
        if (ch == this.newLine) {
            this.appendNewLine();
        } else {
            super.append(ch);
        }
    }

    public void writeCharsAndReset(Writer writer) throws IOException {
        if (this.index - this.whitespaceCount > 0) {
            writer.write(this.chars, 0, this.index - this.whitespaceCount);
        } else if (this.emptyChars != null) {
            writer.write(this.emptyChars, 0, this.emptyChars.length);
        }
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void appendNewLine() {
        super.append(this.lineSeparator1);
        if (this.lineSeparator2 != '\u0000') {
            super.append(this.lineSeparator2);
        }
    }
}

