% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_apply.R
\name{spark_apply}
\alias{spark_apply}
\title{Apply an R Function in Spark}
\usage{
spark_apply(x, f, columns = colnames(x), memory = TRUE, group_by = NULL,
  packages = TRUE, ...)
}
\arguments{
\item{x}{An object (usually a \code{spark_tbl}) coercable to a Spark DataFrame.}

\item{f}{A function that transforms a data frame partition into a data frame.
The function \code{f} has signature \code{f(df, group1, group2, ...)} where
\code{df} is a data frame with the data to be processed and \code{group1} to
\code{groupN} contain the values of the \code{group_by} values. When
\code{group_by} is not specified, \code{f} takes only one argument.}

\item{columns}{A vector of column names or a named vector of column types for
the transformed object. Defaults to the names from the original object and
adds indexed column names when not enough columns are specified.}

\item{memory}{Boolean; should the table be cached into memory?}

\item{group_by}{Column name used to group by data frame partitions.}

\item{packages}{Boolean to distribute \code{.libPaths()} packages to each node,
  a list of packages to distribute, or a package bundle created with
  \code{spark_apply_bundle()}.

  For clusters using Livy or Yarn cluster mode, \code{packages} must
  point to a package bundle created using \code{spark_apply_bundle()}
  and made available as a Spark file using \code{config$sparklyr.shell.files}.

  For offline clusters where \code{available.packages()} is not available,
  manually download the packages database from
 https://cran.r-project.org/web/packages/packages.rds and set
  \code{Sys.setenv(sparklyr.apply.packagesdb = "<pathl-to-rds>")}. Otherwise,
  all packages will be used by default.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Applies an R function to a Spark object (typically, a Spark DataFrame).
}
