/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m1A!\u0001\u0002\u0001\u000b\t91k\\;sG\u0016\u001c(\"A\u0002\u0002\u0011M\u0004\u0018M]6msJ\u001c\u0001a\u0005\u0002\u0001\rA\u0011qAC\u0007\u0002\u0011)\t\u0011\"A\u0003tG\u0006d\u0017-\u0003\u0002\f\u0011\t1\u0011I\\=SK\u001aDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005A\u0001Q\"\u0001\u0002\t\u000bI\u0001A\u0011A\n\u0002\u000fM|WO]2fgV\tA\u0003\u0005\u0002\u001619\u0011qAF\u0005\u0003/!\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011q\u0003\u0003")
public class Sources {
    public String sources() {
        return "\n#' A helper function to retrieve values from \\code{spark_config()}\n#'\n#' @param config The configuration list from \\code{spark_config()}\n#' @param name The name of the configuration entry\n#' @param default The default value to use when entry is not present\n#'\n#' @keywords internal\n#' @export\nspark_config_value <- function(config, name, default = NULL) {\n  if (getOption(\"sparklyr.test.enforce.config\", FALSE) && any(grepl(\"^sparklyr.\", name))) {\n    settings <- get(\"spark_config_settings\")()\n    if (!any(name %in% settings$name)) {\n      stop(\"Config value '\", name[[1]], \"' not described in spark_config_settings()\")\n    }\n  }\n\n  name_exists <- name %in% names(config)\n  if (!any(name_exists)) {\n    name_exists <- name %in% names(options())\n    if (!any(name_exists)) {\n      value <- default\n    } else {\n      name_primary <- name[name_exists][[1]]\n      value <- getOption(name_primary)\n    }\n  } else {\n    name_primary <- name[name_exists][[1]]\n    value <- config[[name_primary]]\n  }\n\n  if (is.function(value)) value <- value()\n  value\n}\n\nspark_config_integer <- function(config, name, default = NULL) {\n  as.integer(spark_config_value(config, name, default))\n}\n\nspark_config_logical <- function(config, name, default = NULL) {\n  as.logical(spark_config_value(config, name, default))\n}\n#' Check whether the connection is open\n#'\n#' @param sc \\code{spark_connection}\n#'\n#' @keywords internal\n#'\n#' @export\nconnection_is_open <- function(sc) {\n  UseMethod(\"connection_is_open\")\n}\nread_bin <- function(con, what, n, endian = NULL) {\n  UseMethod(\"read_bin\")\n}\n\nread_bin.default <- function(con, what, n, endian = NULL) {\n  if (is.null(endian)) readBin(con, what, n) else readBin(con, what, n, endian = endian)\n}\n\nread_bin_wait <- function(con, what, n, endian = NULL) {\n  sc <- con\n  con <- if (!is.null(sc$state) && identical(sc$state$use_monitoring, TRUE)) sc$monitoring else sc$backend\n\n  timeout <- spark_config_value(sc$config, \"sparklyr.backend.timeout\", 30 * 24 * 60 * 60)\n  progressInterval <- spark_config_value(sc$config, \"sparklyr.progress.interval\", 3)\n\n  result <- if (is.null(endian)) readBin(con, what, n) else readBin(con, what, n, endian = endian)\n\n  progressTimeout <- Sys.time() + progressInterval\n  if (is.null(sc$state$progress))\n    sc$state$progress <- new.env()\n  progressUpdated <- FALSE\n\n  waitInterval <- 0\n  commandStart <- Sys.time()\n  while(length(result) == 0 && commandStart + timeout > Sys.time()) {\n    Sys.sleep(waitInterval)\n    waitInterval <- min(0.1, waitInterval + 0.01)\n\n    result <- if (is.null(endian)) readBin(con, what, n) else readBin(con, what, n, endian = endian)\n\n    if (Sys.time() > progressTimeout) {\n      progressTimeout <- Sys.time() + progressInterval\n      if (exists(\"connection_progress\")) {\n        connection_progress(sc)\n        progressUpdated <- TRUE\n      }\n    }\n  }\n\n  if (progressUpdated) connection_progress_terminated(sc)\n\n  if (commandStart + timeout <= Sys.time()) {\n    stop(\"Operation timed out, increase config option sparklyr.backend.timeout if needed.\")\n  }\n\n  result\n}\n\nread_bin.spark_connection <- function(con, what, n, endian = NULL) {\n  read_bin_wait(con, what, n, endian)\n}\n\nread_bin.spark_worker_connection <- function(con, what, n, endian = NULL) {\n  read_bin_wait(con, what, n, endian)\n}\n\nreadObject <- function(con) {\n  # Read type first\n  type <- readType(con)\n  readTypedObject(con, type)\n}\n\nreadTypedObject <- function(con, type) {\n  switch (type,\n          \"i\" = readInt(con),\n          \"c\" = readString(con),\n          \"b\" = readBoolean(con),\n          \"d\" = readDouble(con),\n          \"r\" = readRaw(con),\n          \"D\" = readDate(con),\n          \"t\" = readTime(con),\n          \"a\" = readArray(con),\n          \"l\" = readList(con),\n          \"e\" = readEnv(con),\n          \"s\" = readStruct(con),\n          \"n\" = NULL,\n          \"j\" = getJobj(con, readString(con)),\n          stop(paste(\"Unsupported type for deserialization\", type)))\n}\n\nreadString <- function(con) {\n  stringLen <- readInt(con)\n  string <- \"\"\n\n  if (stringLen > 0) {\n    raw <- read_bin(con, raw(), stringLen, endian = \"big\")\n    string <- rawToChar(raw)\n  }\n\n  Encoding(string) <- \"UTF-8\"\n  string\n}\n\nreadDateArray <- function(con, n = 1) {\n  r <- readTime(con, n)\n  if (getOption(\"sparklyr.collect.datechars\", FALSE)) r else as.Date(r)\n}\n\nreadInt <- function(con, n = 1) {\n  if (n == 0)\n    integer(0)\n  else\n    read_bin(con, integer(), n = n, endian = \"big\")\n}\n\nreadDouble <- function(con, n = 1) {\n  if (n == 0)\n    double(0)\n  else\n    read_bin(con, double(), n = n, endian = \"big\")\n}\n\nreadBoolean <- function(con, n = 1) {\n  if (n == 0)\n    logical(0)\n  else\n    as.logical(readInt(con, n = n))\n}\n\nreadType <- function(con) {\n  rawToChar(read_bin(con, \"raw\", n = 1L))\n}\n\nreadDate <- function(con) {\n  as.Date(readString(con))\n}\n\nreadTime <- function(con, n = 1) {\n  if (identical(n, 0))\n    as.POSIXct(character(0))\n  else {\n    t <- readDouble(con, n)\n    timeNA <- as.POSIXct(0, origin = \"1970-01-01\", tz = \"UTC\")\n\n    r <- as.POSIXct(t, origin = \"1970-01-01\", tz = \"UTC\")\n    if (getOption(\"sparklyr.collect.datechars\", FALSE))\n      as.character(r)\n    else {\n      r[r == timeNA] <- as.POSIXct(NA)\n      r\n    }\n  }\n}\n\nreadArray <- function(con) {\n  type <- readType(con)\n  len <- readInt(con)\n\n  if (type == \"d\") {\n    return(readDouble(con, n = len))\n  } else if (type == \"i\") {\n    return(readInt(con, n = len))\n  } else if (type == \"b\") {\n    return(readBoolean(con, n = len))\n  } else if (type == \"t\") {\n    return(readTime(con, n = len))\n  } else if (type == \"D\") {\n    return(readDateArray(con, n = len))\n  }\n\n  if (len > 0) {\n    l <- vector(\"list\", len)\n    for (i in 1:len) {\n      l[[i]] <- readTypedObject(con, type)\n    }\n    l\n  } else {\n    list()\n  }\n}\n\n# Read a list. Types of each element may be different.\n# Null objects are read as NA.\nreadList <- function(con) {\n  len <- readInt(con)\n  if (len > 0) {\n    l <- vector(\"list\", len)\n    for (i in 1:len) {\n      elem <- readObject(con)\n      if (is.null(elem)) {\n        elem <- NA\n      }\n      l[[i]] <- elem\n    }\n    l\n  } else {\n    list()\n  }\n}\n\nreadEnv <- function(con) {\n  env <- new.env()\n  len <- readInt(con)\n  if (len > 0) {\n    for (i in 1:len) {\n      key <- readString(con)\n      value <- readObject(con)\n      env[[key]] <- value\n    }\n  }\n  env\n}\n\n# Convert a named list to struct so that\n# SerDe won't confuse between a normal named list and struct\nlistToStruct <- function(list) {\n  stopifnot(class(list) == \"list\")\n  stopifnot(!is.null(names(list)))\n  class(list) <- \"struct\"\n  list\n}\n\n# Read a field of StructType from DataFrame\n# into a named list in R whose class is \"struct\"\nreadStruct <- function(con) {\n  names <- readObject(con)\n  fields <- readObject(con)\n  names(fields) <- names\n  listToStruct(fields)\n}\n\nreadRaw <- function(con) {\n  dataLen <- readInt(con)\n  if (dataLen == 0)\n    raw()\n  else\n    read_bin(con, raw(), as.integer(dataLen), endian = \"big\")\n}\nwait_connect_gateway <- function(gatewayAddress, gatewayPort, config, isStarting) {\n  waitSeconds <- if (isStarting)\n    spark_config_value(config, \"sparklyr.connect.timeout\", 60)\n  else\n    spark_config_value(config, \"sparklyr.gateway.timeout\", 1)\n\n  gateway <- NULL\n  commandStart <- Sys.time()\n\n  while (is.null(gateway) && Sys.time() < commandStart + waitSeconds) {\n    tryCatch({\n      suppressWarnings({\n        timeout <- spark_config_value(config, \"sparklyr.gateway.interval\", 1)\n        gateway <- socketConnection(host = gatewayAddress,\n                                    port = gatewayPort,\n                                    server = FALSE,\n                                    blocking = TRUE,\n                                    open = \"rb\",\n                                    timeout = timeout)\n      })\n    }, error = function(err) {\n    })\n\n    startWait <- spark_config_value(config, \"sparklyr.gateway.wait\", 50 / 1000)\n    Sys.sleep(startWait)\n  }\n\n  gateway\n}\n\nspark_gateway_commands <- function() {\n  list(\n    \"GetPorts\" = 0,\n    \"RegisterInstance\" = 1\n  )\n}\n\nquery_gateway_for_port <- function(gateway, sessionId, config, isStarting) {\n  waitSeconds <- if (isStarting)\n    spark_config_value(config, \"sparklyr.connect.timeout\", 60)\n  else\n    spark_config_value(config, \"sparklyr.gateway.timeout\", 1)\n\n  writeInt(gateway, spark_gateway_commands()[[\"GetPorts\"]])\n  writeInt(gateway, sessionId)\n  writeInt(gateway, if (isStarting) waitSeconds else 0)\n\n  backendSessionId <- NULL\n  redirectGatewayPort <- NULL\n\n  commandStart <- Sys.time()\n  while(length(backendSessionId) == 0 && commandStart + waitSeconds > Sys.time()) {\n    backendSessionId <- readInt(gateway)\n    Sys.sleep(0.1)\n  }\n\n  redirectGatewayPort <- readInt(gateway)\n  backendPort <- readInt(gateway)\n\n  if (length(backendSessionId) == 0 || length(redirectGatewayPort) == 0 || length(backendPort) == 0) {\n    if (isStarting)\n      stop(\"Sparklyr gateway did not respond while retrieving ports information after \", waitSeconds, \" seconds\")\n    else\n      return(NULL)\n  }\n\n  list(\n    gateway = gateway,\n    backendPort = backendPort,\n    redirectGatewayPort = redirectGatewayPort\n  )\n}\n\nspark_connect_gateway <- function(\n  gatewayAddress,\n  gatewayPort,\n  sessionId,\n  config,\n  isStarting = FALSE) {\n\n  # try connecting to existing gateway\n  gateway <- wait_connect_gateway(gatewayAddress, gatewayPort, config, isStarting)\n\n  if (is.null(gateway)) {\n    if (isStarting)\n      stop(\n        \"Gateway in \", gatewayAddress, \":\", gatewayPort, \" did not respond.\")\n\n    NULL\n  }\n  else {\n    worker_log(\"is querying ports from backend using port \", gatewayPort)\n\n    gatewayPortsQuery <- query_gateway_for_port(gateway, sessionId, config, isStarting)\n    if (is.null(gatewayPortsQuery) && !isStarting) {\n      close(gateway)\n      return(NULL)\n    }\n\n    redirectGatewayPort <- gatewayPortsQuery$redirectGatewayPort\n    backendPort <- gatewayPortsQuery$backendPort\n\n    worker_log(\"found redirect gateway port \", redirectGatewayPort)\n\n    if (redirectGatewayPort == 0) {\n      close(gateway)\n\n      if (isStarting)\n        stop(\"Gateway in \", gatewayAddress, \":\", gatewayPort, \" does not have the requested session registered\")\n\n      NULL\n    } else if(redirectGatewayPort != gatewayPort) {\n      close(gateway)\n\n      spark_connect_gateway(gatewayAddress, redirectGatewayPort, sessionId, config, isStarting)\n    }\n    else {\n      list(\n        gateway = gateway,\n        backendPort = backendPort\n      )\n    }\n  }\n}\ncore_invoke_sync_socket <- function(sc)\n{\n  flush <- c(1)\n  while(length(flush) > 0) {\n    flush <- readBin(sc$backend, raw(), 1000)\n\n    # while flushing monitored connections we don't want to hang forever\n    if (identical(sc$state$use_monitoring, TRUE)) break;\n  }\n}\n\ncore_invoke_sync <- function(sc)\n{\n  # sleep until connection clears is back on valid state\n  while (!core_invoke_synced(sc)) {\n    Sys.sleep(1)\n    core_invoke_sync_socket(sc)\n  }\n}\n\ncore_invoke_cancel_running <- function(sc)\n{\n  if (is.null(spark_context(sc)))\n    return()\n\n  # if something fails while using a monitored connection we don't cancel jobs\n  if (identical(sc$state$use_monitoring, TRUE))\n    return()\n\n  # if something fails while cancelling jobs we don't cancel jobs, this can\n  # happen in OutOfMemory errors that shut down the spark context\n  if (identical(sc$state$cancelling_all_jobs, TRUE))\n    return()\n\n  connection_progress_context(sc, function() {\n    sc$state$cancelling_all_jobs <- TRUE\n    on.exit(sc$state$cancelling_all_jobs <- FALSE)\n    invoke(spark_context(sc), \"cancelAllJobs\")\n  })\n\n  if (exists(\"connection_progress_terminated\")) connection_progress_terminated(sc)\n}\n\nwrite_bin_args <- function(backend, object, static, method, args) {\n  rc <- rawConnection(raw(), \"r+\")\n  writeString(rc, object)\n  writeBoolean(rc, static)\n  writeString(rc, method)\n\n  writeInt(rc, length(args))\n  writeArgs(rc, args)\n  bytes <- rawConnectionValue(rc)\n  close(rc)\n\n  rc <- rawConnection(raw(0), \"r+\")\n  writeInt(rc, length(bytes))\n  writeBin(bytes, rc)\n  con <- rawConnectionValue(rc)\n  close(rc)\n\n  writeBin(con, backend)\n}\n\ncore_invoke_synced <- function(sc)\n{\n  if (is.null(sc))\n    stop(\"The connection is no longer valid.\")\n\n  backend <- core_invoke_socket(sc)\n  echo_id <- \"sparklyr\"\n\n  write_bin_args(backend, \"Handler\", TRUE, \"echo\", echo_id)\n\n  returnStatus <- readInt(backend)\n\n  if (length(returnStatus) == 0 || returnStatus != 0) {\n    FALSE\n  }\n  else {\n    object <- readObject(sc)\n    identical(object, echo_id)\n  }\n}\n\ncore_invoke_socket <- function(sc) {\n  if (identical(sc$state$use_monitoring, TRUE))\n    sc$monitoring\n  else\n    sc$backend\n}\n\ncore_invoke_socket_name <- function(sc) {\n  if (identical(sc$state$use_monitoring, TRUE))\n    \"monitoring\"\n  else\n    \"backend\"\n}\n\ncore_invoke_method <- function(sc, static, object, method, ...)\n{\n  if (is.null(sc))\n    stop(\"The connection is no longer valid.\")\n\n  args <- list(...)\n\n  # initialize status if needed\n  if (is.null(sc$state$status))\n    sc$state$status <- list()\n\n  # choose connection socket\n  backend <- core_invoke_socket(sc)\n  connection_name <- core_invoke_socket_name(sc)\n\n  if (!identical(object, \"Handler\") && getOption(\"sparklyr.connection.cancellable\", TRUE)) {\n    # if connection still running, sync to valid state\n    if (identical(sc$state$status[[connection_name]], \"running\"))\n      core_invoke_sync(sc)\n\n    # while exiting this function, if interrupted (still running), cancel server job\n    on.exit(core_invoke_cancel_running(sc))\n\n    sc$state$status[[connection_name]] <- \"running\"\n  }\n\n  # if the object is a jobj then get it's id\n  if (inherits(object, \"spark_jobj\"))\n    object <- object$id\n\n  write_bin_args(backend, object, static, method, args)\n\n  if (identical(object, \"Handler\") &&\n      (identical(method, \"terminateBackend\") || identical(method, \"stopBackend\"))) {\n    # by the time we read response, backend might be already down.\n    return(NULL)\n  }\n\n  returnStatus <- readInt(sc)\n\n  if (length(returnStatus) == 0) {\n    # read the spark log\n    msg <- core_read_spark_log_error(sc)\n\n    withr::with_options(list(\n      warning.length = 8000\n    ), {\n      stop(\n        \"Unexpected state in sparklyr backend: \",\n        msg,\n        call. = FALSE)\n    })\n  }\n\n  if (returnStatus != 0) {\n    # get error message from backend and report to R\n    msg <- readString(sc)\n    withr::with_options(list(\n      warning.length = 8000\n    ), {\n      if (nzchar(msg)) {\n        core_handle_known_errors(sc, msg)\n\n        stop(msg, call. = FALSE)\n      } else {\n        # read the spark log\n        msg <- core_read_spark_log_error(sc)\n        stop(msg, call. = FALSE)\n      }\n    })\n  }\n\n  object <- readObject(sc)\n\n  sc$state$status[[connection_name]] <- \"ready\"\n  on.exit(NULL)\n\n  attach_connection(object, sc)\n}\n\njobj_subclass.shell_backend <- function(con) {\n  \"shell_jobj\"\n}\n\njobj_subclass.spark_connection <- function(con) {\n  \"shell_jobj\"\n}\n\njobj_subclass.spark_worker_connection <- function(con) {\n  \"shell_jobj\"\n}\n\ncore_handle_known_errors <- function(sc, msg) {\n  # Some systems might have an invalid hostname that Spark <= 2.0.1 fails to handle\n  # gracefully and triggers unexpected errors such as #532. Under these versions,\n  # we proactevely test getLocalHost() to warn users of this problem.\n  if (grepl(\"ServiceConfigurationError.*tachyon\", msg, ignore.case = TRUE)) {\n    warning(\n      \"Failed to retrieve localhost, please validate that the hostname is correctly mapped. \",\n      \"Consider running `hostname` and adding that entry to your `/etc/hosts` file.\"\n    )\n  }\n  else if (grepl(\"check worker logs for details\", msg, ignore.case = TRUE) &&\n           spark_master_is_local(sc$master)) {\n    abort_shell(\n      \"sparklyr worker rscript failure, check worker logs for details\",\n      NULL, NULL, sc$output_file, sc$error_file)\n  }\n}\n\ncore_read_spark_log_error <- function(sc) {\n  # if there was no error message reported, then\n  # return information from the Spark logs. return\n  # all those with most recent timestamp\n  msg <- \"failed to invoke spark command (unknown reason)\"\n  try(silent = TRUE, {\n    log <- readLines(sc$output_file)\n    splat <- strsplit(log, \"\\\\s+\", perl = TRUE)\n    n <- length(splat)\n    timestamp <- splat[[n]][[2]]\n    regex <- paste(\"\\\\b\", timestamp, \"\\\\b\", sep = \"\")\n    entries <- grep(regex, log, perl = TRUE, value = TRUE)\n    pasted <- paste(entries, collapse = \"\\n\")\n    msg <- paste(\"failed to invoke spark command\", pasted, sep = \"\\n\")\n  })\n  msg\n}\n#' Retrieve a Spark JVM Object Reference\n#'\n#' This S3 generic is used for accessing the underlying Java Virtual Machine\n#' (JVM) Spark objects associated with \\R objects. These objects act as\n#' references to Spark objects living in the JVM. Methods on these objects\n#' can be called with the \\code{\\link{invoke}} family of functions.\n#'\n#' @param x An \\R object containing, or wrapping, a \\code{spark_jobj}.\n#' @param ... Optional arguments; currently unused.\n#'\n#' @seealso \\code{\\link{invoke}}, for calling methods on Java object references.\n#'\n#' @exportClass spark_jobj\n#' @export\nspark_jobj <- function(x, ...) {\n  UseMethod(\"spark_jobj\")\n}\n\nspark_jobj_id <- function(x) {\n  x$id\n}\n\n#' @export\nspark_jobj.default <- function(x, ...) {\n  stop(\"Unable to retrieve a spark_jobj from object of class \",\n       paste(class(x), collapse = \" \"), call. = FALSE)\n}\n\n#' @export\nspark_jobj.spark_jobj <- function(x, ...) {\n  x\n}\n\n#' @export\nprint.spark_jobj <- function(x, ...) {\n  print_jobj(spark_connection(x), x, ...)\n}\n\n#' Generic method for print jobj for a connection type\n#'\n#' @param sc \\code{spark_connection} (used for type dispatch)\n#' @param jobj Object to print\n#'\n#' @keywords internal\n#'\n#' @export\nprint_jobj <- function(sc, jobj, ...) {\n  UseMethod(\"print_jobj\")\n}\n\n\n# Maintain a reference count of Java object references\n# This allows us to GC the java object when it is safe\n.validJobjs <- new.env(parent = emptyenv())\n\n# List of object ids to be removed\n.toRemoveJobjs <- new.env(parent = emptyenv())\n\n# Check if jobj was created with the current SparkContext\nisValidJobj <- function(jobj) {\n  TRUE\n}\n\ngetJobj <- function(con, objId) {\n  newObj <- jobj_create(con, objId)\n  if (exists(objId, .validJobjs)) {\n    .validJobjs[[objId]] <- .validJobjs[[objId]] + 1\n  } else {\n    .validJobjs[[objId]] <- 1\n  }\n  newObj\n}\n\njobj_subclass <- function(con) {\n  UseMethod(\"jobj_subclass\")\n}\n\n# Handler for a java object that exists on the backend.\njobj_create <- function(con, objId) {\n  if (!is.character(objId)) {\n    stop(\"object id must be a character\")\n  }\n  # NOTE: We need a new env for a jobj as we can only register\n  # finalizers for environments or external references pointers.\n  obj <- structure(new.env(parent = emptyenv()), class = c(\"spark_jobj\", jobj_subclass(con)))\n  obj$id <- objId\n\n  # Register a finalizer to remove the Java object when this reference\n  # is garbage collected in R\n  reg.finalizer(obj, cleanup.jobj)\n  obj\n}\n\njobj_info <- function(jobj) {\n  if (!inherits(jobj, \"spark_jobj\"))\n    stop(\"'jobj_info' called on non-jobj\")\n\n  class <- NULL\n  repr <- NULL\n\n  tryCatch({\n    class <- invoke(jobj, \"getClass\")\n    if (inherits(class, \"spark_jobj\"))\n      class <- invoke(class, \"getName\")\n  }, error = function(e) {\n  })\n  tryCatch({\n    repr <- invoke(jobj, \"toString\")\n  }, error = function(e) {\n  })\n  list(\n    class = class,\n    repr  = repr\n  )\n}\n\njobj_inspect <- function(jobj) {\n  print(jobj)\n  if (!connection_is_open(spark_connection(jobj)))\n    return(jobj)\n\n  class <- invoke(jobj, \"getClass\")\n\n  cat(\"Fields:\\n\")\n  fields <- invoke(class, \"getDeclaredFields\")\n  lapply(fields, function(field) { print(field) })\n\n  cat(\"Methods:\\n\")\n  methods <- invoke(class, \"getDeclaredMethods\")\n  lapply(methods, function(method) { print(method) })\n\n  jobj\n}\n\ncleanup.jobj <- function(jobj) {\n  if (isValidJobj(jobj)) {\n    objId <- jobj$id\n    # If we don't know anything about this jobj, ignore it\n    if (exists(objId, envir = .validJobjs)) {\n      .validJobjs[[objId]] <- .validJobjs[[objId]] - 1\n\n      if (.validJobjs[[objId]] == 0) {\n        rm(list = objId, envir = .validJobjs)\n        # NOTE: We cannot call removeJObject here as the finalizer may be run\n        # in the middle of another RPC. Thus we queue up this object Id to be removed\n        # and then run all the removeJObject when the next RPC is called.\n        .toRemoveJobjs[[objId]] <- 1\n      }\n    }\n  }\n}\n\nclearJobjs <- function() {\n  valid <- ls(.validJobjs)\n  rm(list = valid, envir = .validJobjs)\n\n  removeList <- ls(.toRemoveJobjs)\n  rm(list = removeList, envir = .toRemoveJobjs)\n}\n\nattach_connection <- function(jobj, connection) {\n\n  if (inherits(jobj, \"spark_jobj\")) {\n    jobj$connection <- connection\n  }\n  else if (is.list(jobj) || inherits(jobj, \"struct\")) {\n    jobj <- lapply(jobj, function(e) {\n      attach_connection(e, connection)\n    })\n  }\n  else if (is.environment(jobj)) {\n    jobj <- eapply(jobj, function(e) {\n      attach_connection(e, connection)\n    })\n  }\n\n  jobj\n}\n# Utility functions to serialize R objects so they can be read in Java.\n\n# nolint start\n# Type mapping from R to Java\n#\n# NULL -> Void\n# integer -> Int\n# character -> String\n# logical -> Boolean\n# double, numeric -> Double\n# raw -> Array[Byte]\n# Date -> Date\n# POSIXct,POSIXlt -> Timestamp\n#\n# list[T] -> Array[T], where T is one of above mentioned types\n# environment -> Map[String, T], where T is a native type\n# jobj -> Object, where jobj is an object created in the backend\n# nolint end\n\ngetSerdeType <- function(object) {\n  type <- class(object)[[1]]\n\n  if (type != \"list\") {\n    type\n  } else {\n    # Check if all elements are of same type\n    elemType <- unique(sapply(object, function(elem) { getSerdeType(elem) }))\n    if (length(elemType) <= 1) {\n\n      # Check that there are no NAs in arrays since they are unsupported in scala\n      hasNAs <- any(is.na(object))\n\n      if (hasNAs) {\n        \"list\"\n      } else {\n        \"array\"\n      }\n    } else {\n      \"list\"\n    }\n  }\n}\n\nwriteObject <- function(con, object, writeType = TRUE) {\n  type <- class(object)[[1]]\n\n  if (type %in% c(\"integer\", \"character\", \"logical\", \"double\", \"numeric\", \"factor\", \"Date\", \"POSIXct\")) {\n    if (is.na(object)) {\n      object <- NULL\n      type <- \"NULL\"\n    }\n  }\n\n  serdeType <- getSerdeType(object)\n  if (writeType) {\n    writeType(con, serdeType)\n  }\n  switch(serdeType,\n         NULL = writeVoid(con),\n         integer = writeInt(con, object),\n         character = writeString(con, object),\n         logical = writeBoolean(con, object),\n         double = writeDouble(con, object),\n         numeric = writeDouble(con, object),\n         raw = writeRaw(con, object),\n         array = writeArray(con, object),\n         list = writeList(con, object),\n         struct = writeList(con, object),\n         spark_jobj = writeJobj(con, object),\n         environment = writeEnv(con, object),\n         Date = writeDate(con, object),\n         POSIXlt = writeTime(con, object),\n         POSIXct = writeTime(con, object),\n         factor = writeFactor(con, object),\n         `data.frame` = writeList(con, object),\n         stop(paste(\"Unsupported type for serialization\", type)))\n}\n\nwriteVoid <- function(con) {\n  # no value for NULL\n}\n\nwriteJobj <- function(con, value) {\n  if (!isValidJobj(value)) {\n    stop(\"invalid jobj \", value$id)\n  }\n  writeString(con, value$id)\n}\n\nwriteString <- function(con, value) {\n  utfVal <- enc2utf8(value)\n  writeInt(con, as.integer(nchar(utfVal, type = \"bytes\") + 1))\n  writeBin(utfVal, con, endian = \"big\", useBytes = TRUE)\n}\n\nwriteInt <- function(con, value) {\n  writeBin(as.integer(value), con, endian = \"big\")\n}\n\nwriteDouble <- function(con, value) {\n  writeBin(value, con, endian = \"big\")\n}\n\nwriteBoolean <- function(con, value) {\n  # TRUE becomes 1, FALSE becomes 0\n  writeInt(con, as.integer(value))\n}\n\nwriteRaw <- function(con, batch) {\n  writeInt(con, length(batch))\n  writeBin(batch, con, endian = \"big\")\n}\n\nwriteType <- function(con, class) {\n  type <- switch(class,\n                 NULL = \"n\",\n                 integer = \"i\",\n                 character = \"c\",\n                 logical = \"b\",\n                 double = \"d\",\n                 numeric = \"d\",\n                 raw = \"r\",\n                 array = \"a\",\n                 list = \"l\",\n                 struct = \"s\",\n                 spark_jobj = \"j\",\n                 environment = \"e\",\n                 Date = \"D\",\n                 POSIXlt = \"t\",\n                 POSIXct = \"t\",\n                 factor = \"c\",\n                 `data.frame` = \"l\",\n                 stop(paste(\"Unsupported type for serialization\", class)))\n  writeBin(charToRaw(type), con)\n}\n\n# Used to pass arrays where all the elements are of the same type\nwriteArray <- function(con, arr) {\n  # TODO: Empty lists are given type \"character\" right now.\n  # This may not work if the Java side expects array of any other type.\n  if (length(arr) == 0) {\n    elemType <- class(\"somestring\")\n  } else {\n    elemType <- getSerdeType(arr[[1]])\n  }\n\n  writeType(con, elemType)\n  writeInt(con, length(arr))\n\n  if (length(arr) > 0) {\n    for (a in arr) {\n      writeObject(con, a, FALSE)\n    }\n  }\n}\n\n# Used to pass arrays where the elements can be of different types\nwriteList <- function(con, list) {\n  writeInt(con, length(list))\n  for (elem in list) {\n    writeObject(con, elem)\n  }\n}\n\n# Used to pass in hash maps required on Java side.\nwriteEnv <- function(con, env) {\n  len <- length(env)\n\n  writeInt(con, len)\n  if (len > 0) {\n    writeArray(con, as.list(ls(env)))\n    vals <- lapply(ls(env), function(x) { env[[x]] })\n    writeList(con, as.list(vals))\n  }\n}\n\nwriteDate <- function(con, date) {\n  writeString(con, as.character(date))\n}\n\nwriteTime <- function(con, time) {\n  writeDouble(con, as.double(time))\n}\n\nwriteFactor <- function(con, factor) {\n  writeString(con, as.character(factor))\n}\n\n# Used to serialize in a list of objects where each\n# object can be of a different type. Serialization format is\n# <object type> <object> for each object\nwriteArgs <- function(con, args) {\n  if (length(args) > 0) {\n    for (a in args) {\n      writeObject(con, a)\n    }\n  }\n}\ncore_get_package_function <- function(packageName, functionName) {\n  if (packageName %in% rownames(installed.packages()) &&\n      exists(functionName, envir = asNamespace(packageName)))\n    get(functionName, envir = asNamespace(packageName))\n  else\n    NULL\n}\nworker_config_serialize <- function(config) {\n  paste(\n    if (isTRUE(config$debug)) \"TRUE\" else \"FALSE\",\n    spark_config_value(config, \"sparklyr.worker.gateway.port\", \"8880\"),\n    spark_config_value(config, \"sparklyr.worker.gateway.address\", \"localhost\"),\n    if (isTRUE(config$profile)) \"TRUE\" else \"FALSE\",\n    if (isTRUE(config$schema)) \"TRUE\" else \"FALSE\",\n    sep = \";\"\n  )\n}\n\nworker_config_deserialize <- function(raw) {\n  parts <- strsplit(raw, \";\")[[1]]\n\n  list(\n    debug = as.logical(parts[[1]]),\n    sparklyr.gateway.port = as.integer(parts[[2]]),\n    sparklyr.gateway.address = parts[[3]],\n    profile = as.logical(parts[[4]]),\n    schema = as.logical(parts[[5]])\n  )\n}\nspark_worker_apply <- function(sc, config) {\n  hostContextId <- worker_invoke_method(sc, FALSE, \"Handler\", \"getHostContext\")\n  worker_log(\"retrieved worker context id \", hostContextId)\n\n  context <- structure(\n    class = c(\"spark_jobj\", \"shell_jobj\"),\n    list(\n      id = hostContextId,\n      connection = sc\n    )\n  )\n\n  worker_log(\"retrieved worker context\")\n\n  bundlePath <- worker_invoke(context, \"getBundlePath\")\n  if (nchar(bundlePath) > 0) {\n    bundleName <- basename(bundlePath)\n    worker_log(\"using bundle name \", bundleName)\n\n    workerRootDir <- worker_invoke_static(sc, \"org.apache.spark.SparkFiles\", \"getRootDirectory\")\n    sparkBundlePath <- file.path(workerRootDir, bundleName)\n\n    worker_log(\"using bundle path \", normalizePath(sparkBundlePath))\n\n    if (!file.exists(sparkBundlePath)) {\n      stop(\"failed to find bundle under SparkFiles root directory\")\n    }\n\n    unbundlePath <- worker_spark_apply_unbundle(\n      sparkBundlePath,\n      workerRootDir,\n      tools::file_path_sans_ext(bundleName)\n    )\n\n    .libPaths(unbundlePath)\n    worker_log(\"updated .libPaths with bundle packages\")\n  }\n  else {\n    spark_env <- worker_invoke_static(sc, \"org.apache.spark.SparkEnv\", \"get\")\n    spark_libpaths <- worker_invoke(worker_invoke(spark_env, \"conf\"), \"get\", \"spark.r.libpaths\", NULL)\n    if (!is.null(spark_libpaths)) .libPaths(spark_libpaths)\n  }\n\n  grouped_by <- worker_invoke(context, \"getGroupBy\")\n  grouped <- !is.null(grouped_by) && length(grouped_by) > 0\n  if (grouped) worker_log(\"working over grouped data\")\n\n  length <- worker_invoke(context, \"getSourceArrayLength\")\n  worker_log(\"found \", length, \" rows\")\n\n  groups <- worker_invoke(context, if (grouped) \"getSourceArrayGroupedSeq\" else \"getSourceArraySeq\")\n  worker_log(\"retrieved \", length(groups), \" rows\")\n\n  closureRaw <- worker_invoke(context, \"getClosure\")\n  closure <- unserialize(closureRaw)\n\n  funcContextRaw <- worker_invoke(context, \"getContext\")\n  funcContext <- unserialize(funcContextRaw)\n\n  closureRLangRaw <- worker_invoke(context, \"getClosureRLang\")\n  if (length(closureRLangRaw) > 0) {\n    worker_log(\"found rlang closure\")\n    closureRLang <- spark_worker_rlang_unserialize()\n    if (!is.null(closureRLang)) {\n      closure <- closureRLang(closureRLangRaw)\n      worker_log(\"created rlang closure\")\n    }\n  }\n\n  if (identical(config$schema, TRUE)) {\n    worker_log(\"is running to compute schema\")\n  }\n\n  columnNames <- worker_invoke(context, \"getColumns\")\n\n  if (!grouped) groups <- list(list(groups))\n\n  all_results <- NULL\n\n  for (group_entry in groups) {\n    # serialized groups are wrapped over single lists\n    data <- group_entry[[1]]\n\n    df <- do.call(rbind.data.frame, c(data, list(stringsAsFactors = FALSE)))\n\n    # rbind removes Date classes so we re-assign them here\n    if (length(data) > 0 && ncol(df) > 0 && nrow(df) > 0) {\n\n      if (any(sapply(data[[1]], function(e) class(e)[[1]]) %in% c(\"Date\", \"POSIXct\"))) {\n        first_row <- data[[1]]\n        for (idx in seq_along(first_row)) {\n          first_class <- class(first_row[[idx]])[[1]]\n          if (identical(first_class, \"Date\")) {\n            df[[idx]] <- as.Date(df[[idx]], origin = \"1970-01-01\")\n          } else if (identical(first_class, \"POSIXct\")) {\n            df[[idx]] <- as.POSIXct(df[[idx]], origin = \"1970-01-01\")\n          }\n        }\n      }\n\n      # cast column to correct type, for instance, when dealing with NAs.\n      for (i in 1:ncol(df)) {\n        target_type <- funcContext$column_types[[i]]\n        if (!is.null(target_type) && class(df[[i]]) != target_type) {\n        df[[i]] <- do.call(paste(\"as\", target_type, sep = \".\"), args = list(df[[i]]))\n        }\n      }\n    }\n\n    result <- NULL\n\n    if (nrow(df) == 0) {\n      worker_log(\"found that source has no rows to be proceesed\")\n    }\n    else {\n      colnames(df) <- columnNames[1: length(colnames(df))]\n\n      closure_params <- length(formals(closure))\n      closure_args <- c(\n        list(df),\n        if (!is.null(funcContext$user_context)) list(funcContext$user_context) else NULL,\n        as.list(\n          if (nrow(df) > 0)\n            lapply(grouped_by, function(group_by_name) df[[group_by_name]][[1]])\n          else\n            NULL\n        )\n      )[0:closure_params]\n\n      worker_log(\"computing closure\")\n      result <- do.call(closure, closure_args)\n      worker_log(\"computed closure\")\n\n      if (!\"data.frame\" %in% class(result)) {\n        worker_log(\"data.frame expected but \", class(result), \" found\")\n        result <- as.data.frame(result)\n      }\n\n      if (!is.data.frame(result)) stop(\"Result from closure is not a data.frame\")\n    }\n\n    if (grouped) {\n      if (nrow(result) > 0) {\n        new_column_values <- lapply(grouped_by, function(grouped_by_name) df[[grouped_by_name]][[1]])\n        names(new_column_values) <- grouped_by\n\n        if(\"AsIs\" %in% class(result)) class(result) <- class(result)[-match(\"AsIs\", class(result))]\n        result <- do.call(\"cbind\", list(new_column_values, result))\n\n        names(result) <- gsub(\"\\\\.\", \"_\", make.unique(names(result)))\n      }\n      else {\n        result <- NULL\n      }\n    }\n\n    firstClass <- function(e) class(e)[[1]]\n\n    if (identical(config$schema, TRUE)) {\n      worker_log(\"updating schema\")\n      result <- data.frame(\n        names = paste(names(result), collapse = \"|\"),\n        types = paste(lapply(result, firstClass), collapse = \"|\")\n      )\n    }\n\n    all_results <- rbind(all_results, result)\n  }\n\n  if (!is.null(all_results) && nrow(all_results) > 0) {\n    worker_log(\"updating \", nrow(all_results), \" rows\")\n\n    all_data <- lapply(1:nrow(all_results), function(i) as.list(all_results[i,]))\n\n    worker_invoke(context, \"setResultArraySeq\", all_data)\n    worker_log(\"updated \", nrow(all_results), \" rows\")\n  } else {\n    worker_log(\"found no rows in closure result\")\n  }\n\n  worker_log(\"finished apply\")\n}\n\nspark_worker_rlang_unserialize <- function() {\n  rlang_unserialize <- core_get_package_function(\"rlang\", \"bytes_unserialise\")\n  if (is.null(rlang_unserialize))\n    core_get_package_function(\"rlanglabs\", \"bytes_unserialise\")\n  else\n    rlang_unserialize\n}\n\nspark_worker_unbundle_path <- function() {\n  file.path(\"sparklyr-bundle\")\n}\n\n#' Extracts a bundle of dependencies required by \\code{spark_apply()}\n#'\n#' @param bundle_path Path to the bundle created using \\code{spark_apply_bundle()}\n#' @param base_path Base path to use while extracting bundles\n#'\n#' @keywords internal\n#' @export\nworker_spark_apply_unbundle <- function(bundle_path, base_path, bundle_name) {\n  extractPath <- file.path(base_path, spark_worker_unbundle_path(), bundle_name)\n  lockFile <- file.path(extractPath, \"sparklyr.lock\")\n\n  if (!dir.exists(extractPath)) dir.create(extractPath, recursive = TRUE)\n\n  if (length(dir(extractPath)) == 0) {\n    worker_log(\"found that the unbundle path is empty, extracting:\", extractPath)\n\n    writeLines(\"\", lockFile)\n    system2(\"tar\", c(\"-xf\", bundle_path, \"-C\", extractPath))\n    unlink(lockFile)\n  }\n\n  if (file.exists(lockFile)) {\n    worker_log(\"found that lock file exists, waiting\")\n    while (file.exists(lockFile)) {\n      Sys.sleep(1)\n    }\n    worker_log(\"completed lock file wait\")\n  }\n\n  extractPath\n}\nspark_worker_connect <- function(\n  sessionId,\n  backendPort = 8880,\n  config = list()) {\n\n  gatewayPort <- spark_config_value(config, \"sparklyr.worker.gateway.port\", backendPort)\n\n  gatewayAddress <- spark_config_value(config, \"sparklyr.worker.gateway.address\", \"localhost\")\n  config <- list()\n\n  worker_log(\"is connecting to backend using port \", gatewayPort)\n\n  gatewayInfo <- spark_connect_gateway(gatewayAddress,\n                                       gatewayPort,\n                                       sessionId,\n                                       config = config,\n                                       isStarting = TRUE)\n\n  worker_log(\"is connected to backend\")\n  worker_log(\"is connecting to backend session\")\n\n  tryCatch({\n    interval <- spark_config_value(config, \"sparklyr.backend.interval\", 1)\n\n    backend <- socketConnection(host = \"localhost\",\n                                port = gatewayInfo$backendPort,\n                                server = FALSE,\n                                blocking = interval > 0,\n                                open = \"wb\",\n                                timeout = interval)\n\n    class(backend) <- c(class(backend), \"shell_backend\")\n  }, error = function(err) {\n    close(gatewayInfo$gateway)\n\n    stop(\n      \"Failed to open connection to backend:\", err$message\n    )\n  })\n\n  worker_log(\"is connected to backend session\")\n\n  sc <- structure(class = c(\"spark_worker_connection\"), list(\n    # spark_connection\n    master = \"\",\n    method = \"shell\",\n    app_name = NULL,\n    config = NULL,\n    # spark_shell_connection\n    spark_home = NULL,\n    backend = backend,\n    gateway = gatewayInfo$gateway,\n    output_file = NULL\n  ))\n\n  worker_log(\"created connection\")\n\n  sc\n}\n\nconnection_is_open.spark_worker_connection <- function(sc) {\n  bothOpen <- FALSE\n  if (!identical(sc, NULL)) {\n    tryCatch({\n      bothOpen <- isOpen(sc$backend) && isOpen(sc$gateway)\n    }, error = function(e) {\n    })\n  }\n  bothOpen\n}\n\nworker_connection <- function(x, ...) {\n  UseMethod(\"worker_connection\")\n}\n\nworker_connection.spark_jobj <- function(x, ...) {\n  x$connection\n}\nworker_invoke_method <- function(sc, static, object, method, ...)\n{\n  core_invoke_method(sc, static, object, method, ...)\n}\n\nworker_invoke <- function(jobj, method, ...) {\n  UseMethod(\"worker_invoke\")\n}\n\nworker_invoke.shell_jobj <- function(jobj, method, ...) {\n  worker_invoke_method(worker_connection(jobj), FALSE, jobj, method, ...)\n}\n\nworker_invoke_static <- function(sc, class, method, ...) {\n  worker_invoke_method(sc, TRUE, class, method, ...)\n}\n\nworker_invoke_new <- function(sc, class, ...) {\n  worker_invoke_method(sc, TRUE, class, \"<init>\", ...)\n}\nworker_log_env <- new.env()\n\nworker_log_session <- function(sessionId) {\n  assign('sessionId', sessionId, envir = worker_log_env)\n}\n\nworker_log_format <- function(message, level = \"INFO\", component = \"RScript\") {\n  paste(\n    format(Sys.time(), \"%y/%m/%d %H:%M:%S\"),\n    \" \",\n    level,\n    \" sparklyr: \",\n    component,\n    \" (\",\n    worker_log_env$sessionId,\n    \") \",\n    message,\n    sep = \"\")\n}\n\nworker_log_level <- function(..., level) {\n  if (is.null(worker_log_env$sessionId)) return()\n\n  args = list(...)\n  message <- paste(args, sep = \"\", collapse = \"\")\n  formatted <- worker_log_format(message, level)\n  cat(formatted, \"\\n\")\n}\n\nworker_log <- function(...) {\n  worker_log_level(..., level = \"INFO\")\n}\n\nworker_log_warning<- function(...) {\n  worker_log_level(..., level = \"WARN\")\n}\n\nworker_log_error <- function(...) {\n  worker_log_level(..., level = \"ERROR\")\n}\n.worker_globals <- new.env(parent = emptyenv())\n\nspark_worker_main <- function(\n  sessionId,\n  backendPort = 8880,\n  configRaw = NULL) {\n\n  spark_worker_hooks()\n\n  tryCatch({\n    worker_log_session(sessionId)\n\n    if (is.null(configRaw)) configRaw <- worker_config_serialize(list())\n\n    config <- worker_config_deserialize(configRaw)\n\n    if (identical(config$profile, TRUE)) {\n      profile_name <- paste(\"spark-apply-\", as.numeric(Sys.time()), \".Rprof\", sep = \"\")\n      worker_log(\"starting new profile in \", file.path(getwd(), profile_name))\n      utils::Rprof(profile_name)\n    }\n\n    if (config$debug) {\n      worker_log(\"exiting to wait for debugging session to attach\")\n\n      # sleep for 1 day to allow long debugging sessions\n      Sys.sleep(60*60*24)\n      return()\n    }\n\n    worker_log(\"is starting\")\n\n    options(sparklyr.connection.cancellable = FALSE)\n\n    sc <- spark_worker_connect(sessionId, backendPort, config)\n    worker_log(\"is connected\")\n\n    spark_worker_apply(sc, config)\n\n    if (identical(config$profile, TRUE)) {\n      # utils::Rprof(NULL)\n      worker_log(\"closing profile\")\n    }\n\n  }, error = function(e) {\n    worker_log_error(\"terminated unexpectedly: \", e$message)\n    if (exists(\".stopLastError\", envir = .worker_globals)) {\n      worker_log_error(\"collected callstack: \\n\", get(\".stopLastError\", envir = .worker_globals))\n    }\n    quit(status = -1)\n  })\n\n  worker_log(\"finished\")\n}\n\nspark_worker_hooks <- function() {\n  unlock <- get(\"unlockBinding\")\n  lock <- get(\"lockBinding\")\n\n  originalStop <- stop\n  unlock(\"stop\",  as.environment(\"package:base\"))\n  assign(\"stop\", function(...) {\n    frame_names <- list()\n    frame_start <- max(1, sys.nframe() - 5)\n    for (i in frame_start:sys.nframe()) {\n      current_call <- sys.call(i)\n      frame_names[[1 + i - frame_start]] <- paste(i, \": \", paste(head(deparse(current_call), 5), collapse = \"\\n\"), sep = \"\")\n    }\n\n    assign(\".stopLastError\", paste(rev(frame_names), collapse = \"\\n\"), envir = .worker_globals)\n    originalStop(...)\n  }, as.environment(\"package:base\"))\n  lock(\"stop\",  as.environment(\"package:base\"))\n}\ndo.call(spark_worker_main, as.list(commandArgs(trailingOnly = TRUE)))\n    ";
    }
}

