% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_read_kafka}
\alias{stream_read_kafka}
\title{Read Kafka Stream}
\usage{
stream_read_kafka(sc, name = NULL, options = list(), ...)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{name}{The name to assign to the newly generated stream.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Reads a Kafka stream as a Spark dataframe stream.
}
\details{
Please note that Kafka requires installing the appropriate
package by setting the \code{packages} parameter to \code{"kafka"} in \code{spark_connect()}
}
\examples{
\dontrun{

library(sparklyr)
sc <- spark_connect(master = "local", version = "2.3", packages = "kafka")

read_options <- list(kafka.bootstrap.servers = "localhost:9092", subscribe = "topic1")
write_options <- list(kafka.bootstrap.servers = "localhost:9092", topic = "topic2")

stream <- stream_read_kafka(sc, options = read_options) \%>\%
  stream_write_kafka(options = write_options)

stream_stop(stream)

}

}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_delta}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_parquet}},
  \code{\link{stream_read_socket}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_console}},
  \code{\link{stream_write_csv}},
  \code{\link{stream_write_delta}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_parquet}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
