/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sparklyr.JVMObjectTracker;
import sparklyr.StructTypeAsJSON;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001\u0002\u001b6\u0001aB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\t\u0002!\t!R\u0003\u0005\u0011\u0002\u0001\u0011*\u0002\u0003^\u0001\u0001q\u0006\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0001g\u0011%i\u0007\u00011AA\u0002\u0013\u0005a\u000eC\u0005u\u0001\u0001\u0007\t\u0011)Q\u0005O\")Q\u000f\u0001C\u0001m\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u00037\u0002A\u0011AA/\u0011\u001d\t\t\u0007\u0001C\u0001\u0003GBq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!a2\u0001\t\u0003\tI\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u00034\u0001!\tA!\u000e\t\u000f\tu\u0002\u0001\"\u0001\u0003@!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B(\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005/\u0002A\u0011\u0001B-\u0011\u001d\u0011y\u0006\u0001C\u0001\u0005CBqAa\u0018\u0001\t\u0003\u0011i\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\tm\u0004\u0001\"\u0001\u0003~!9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005'\u0003A\u0011\u0001BK\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa)\u0001\t\u0003\u0011)\u000bC\u0004\u0003,\u0002!\tA!,\t\u000f\te\u0006\u0001\"\u0001\u0003<\"9!\u0011\u0019\u0001\u0005\u0002\t\r\u0007b\u0002Be\u0001\u0011\u0005!1\u001a\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014(\"\u0001\u001c\u0002\u0011M\u0004\u0018M]6msJ\u001c\u0001a\u0005\u0002\u0001sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fq\u0001\u001e:bG.,'\u000f\u0005\u0002B\u00056\tQ'\u0003\u0002Dk\t\u0001\"JV'PE*,7\r\u001e+sC\u000e\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019;\u0005CA!\u0001\u0011\u0015y$\u00011\u0001A\u0005)\u0011V-\u00193PE*,7\r\u001e\t\u0006u)cEkV\u0005\u0003\u0017n\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016AA5p\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\u001f\u0011\u000bG/Y%oaV$8\u000b\u001e:fC6\u0004\"AO+\n\u0005Y[$\u0001B\"iCJ\u0004\"\u0001W.\u000e\u0003eS!A\u0017)\u0002\t1\fgnZ\u0005\u00039f\u0013aa\u00142kK\u000e$(aC,sSR,wJ\u00196fGR\u0004RA\u000f&`/\n\u0004\"!\u00141\n\u0005\u0005t%\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n!\tQ4-\u0003\u0002ew\t9!i\\8mK\u0006t\u0017\u0001C:rYN+'\u000fR3\u0016\u0003\u001d\u0004BA\u000f5kY&\u0011\u0011n\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005-\u001cQ\"\u0001\u0001\u0011\u0005-$\u0011\u0001D:rYN+'\u000fR3`I\u0015\fHCA8s!\tQ\u0004/\u0003\u0002rw\t!QK\\5u\u0011\u001d\u0019h!!AA\u0002\u001d\f1\u0001\u001f\u00132\u0003%\u0019\u0018\u000f\\*fe\u0012+\u0007%\u0001\tsK\u001eL7\u000f^3s'Fd7+\u001a:EKR\u0011qn\u001e\u0005\u0006K\"\u0001\raZ\u0001\u000fe\u0016\fGm\u00142kK\u000e$H+\u001f9f)\t!&\u0010C\u0003|\u0013\u0001\u0007A*A\u0002eSN\f!B]3bI>\u0013'.Z2u)\t9f\u0010C\u0003|\u0015\u0001\u0007A*A\bsK\u0006$G+\u001f9fI>\u0013'.Z2u)\u00159\u00161AA\u0003\u0011\u0015Y8\u00021\u0001M\u0011\u0019\t9a\u0003a\u0001)\u0006AA-\u0019;b)f\u0004X-A\u0005sK\u0006$')\u001f;fgR!\u0011QBA\r!\u0015Q\u0014qBA\n\u0013\r\t\tb\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004u\u0005U\u0011bAA\fw\t!!)\u001f;f\u0011\u0019\tY\u0002\u0004a\u0001\u0019\u0006\u0011\u0011N\\\u0001\be\u0016\fG-\u00138u)\u0011\t\t#a\n\u0011\u0007i\n\u0019#C\u0002\u0002&m\u00121!\u00138u\u0011\u0019\tY\"\u0004a\u0001\u0019\u0006Q!/Z1e\t>,(\r\\3\u0015\t\u00055\u00121\u0007\t\u0004u\u0005=\u0012bAA\u0019w\t1Ai\\;cY\u0016Da!a\u0007\u000f\u0001\u0004a\u0015a\u0004:fC\u0012\u001cFO]5oO\nKH/Z:\u0015\r\u0005e\u0012qJA)!\u0011\tY$!\u0013\u000f\t\u0005u\u0012Q\t\t\u0004\u0003\u007fYTBAA!\u0015\r\t\u0019eN\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d3(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\niE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fZ\u0004BBA\u000e\u001f\u0001\u0007A\nC\u0004\u0002T=\u0001\r!!\t\u0002\u00071,g.\u0001\u0006sK\u0006$7\u000b\u001e:j]\u001e$B!!\u000f\u0002Z!1\u00111\u0004\tA\u00021\u000b1B]3bI\n{w\u000e\\3b]R\u0019!-a\u0018\t\r\u0005m\u0011\u00031\u0001M\u0003!\u0011X-\u00193ECR,G\u0003BA3\u0003c\u0002B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u0002\u0016aA:rY&!\u0011qNA5\u0005\u0011!\u0015\r^3\t\r\u0005m!\u00031\u0001M\u0003!\u0011X-\u00193US6,G\u0003BA<\u0003{\u0002B!a\u001a\u0002z%!\u00111PA5\u0005%!\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0002\u001cM\u0001\r\u0001T\u0001\re\u0016\fGMQ=uKN\f%O\u001d\u000b\u0005\u0003\u0007\u000b)\tE\u0003;\u0003\u001f\ti\u0001\u0003\u0004\u0002\u001cQ\u0001\r\u0001T\u0001\u000be\u0016\fG-\u00138u\u0003J\u0014H\u0003BAF\u0003\u001b\u0003RAOA\b\u0003CAa!a\u0007\u0016\u0001\u0004a\u0015!\u0004:fC\u0012$u.\u001e2mK\u0006\u0013(\u000f\u0006\u0003\u0002\u0014\u0006U\u0005#\u0002\u001e\u0002\u0010\u00055\u0002BBA\u000e-\u0001\u0007A*\u0001\bsK\u0006$'i\\8mK\u0006t\u0017I\u001d:\u0015\t\u0005m\u0015Q\u0014\t\u0005u\u0005=!\r\u0003\u0004\u0002\u001c]\u0001\r\u0001T\u0001\u000ee\u0016\fGm\u0015;sS:<\u0017I\u001d:\u0015\t\u0005\r\u0016Q\u0015\t\u0006u\u0005=\u0011\u0011\b\u0005\u0007\u00037A\u0002\u0019\u0001'\u0002\u0019I,\u0017\rZ!se\u0006L\u0018I\u001d:\u0015\t\u0005-\u0016Q\u0019\u0019\u0005\u0003[\u000b\u0019\fE\u0003;\u0003\u001f\ty\u000b\u0005\u0003\u00022\u0006MF\u0002\u0001\u0003\f\u0003kK\u0012\u0011!A\u0001\u0006\u0003\t9LA\u0002`IE\nB!!/\u0002@B\u0019!(a/\n\u0007\u0005u6HA\u0004O_RD\u0017N\\4\u0011\u0007i\n\t-C\u0002\u0002Dn\u00121!\u00118z\u0011\u0019\tY\"\u0007a\u0001\u0019\u0006Y!/Z1e\u0019&\u001cH/\u0011:s)\u0011\tY-!61\t\u00055\u0017\u0011\u001b\t\u0006u\u0005=\u0011q\u001a\t\u0005\u0003c\u000b\t\u000eB\u0006\u0002Tj\t\t\u0011!A\u0003\u0002\u0005]&aA0%e!1\u00111\u0004\u000eA\u00021\u000b1B]3bI\u0012\u000bG/Z!seR!\u00111\\Ao!\u0015Q\u0014qBA3\u0011\u0019\tYb\u0007a\u0001\u0019\u0006Y!/Z1e)&lW-\u0011:s)\u0011\t\u0019/!:\u0011\u000bi\ny!a\u001e\t\r\u0005mA\u00041\u0001M\u0003%\u0011X-\u00193BeJ\f\u0017\u0010\u0006\u0003\u0002l\u0006U\b\u0007BAw\u0003c\u0004RAOA\b\u0003_\u0004B!!-\u0002r\u0012Y\u00111_\u000f\u0002\u0002\u0003\u0005)\u0011AA\\\u0005\ryFe\r\u0005\u0006wv\u0001\r\u0001T\u0001\te\u0016\fG\rT5tiR!\u00111`A\u007f!\u0011Q\u0014qB,\t\u000bmt\u0002\u0019\u0001'\u0002\u000fI,\u0017\rZ'baR!!1\u0001B\fa\u0019\u0011)A!\u0004\u0003\u0014AA\u00111\bB\u0004\u0005\u0017\u0011\t\"\u0003\u0003\u0003\n\u00055#aA'baB!\u0011\u0011\u0017B\u0007\t-\u0011yaHA\u0001\u0002\u0003\u0015\t!a.\u0003\u0007}#C\u0007\u0005\u0003\u00022\nMAa\u0003B\u000b?\u0005\u0005\t\u0011!B\u0001\u0003o\u00131a\u0018\u00136\u0011\u0019\tYb\ba\u0001\u0019\u0006IqO]5uKRK\b/\u001a\u000b\u0006_\nu!\u0011\u0005\u0005\u0007\u0005?\u0001\u0003\u0019A0\u0002\u0007\u0011|7\u000fC\u0004\u0003$\u0001\u0002\r!!\u000f\u0002\u000fQL\b/Z*ue\u0006iqO]5uK.+\u0017PV1mk\u0016$ra\u001cB\u0015\u0005W\u0011y\u0003\u0003\u0004\u0003 \u0005\u0002\ra\u0018\u0005\u0007\u0005[\t\u0003\u0019A,\u0002\u0007-,\u0017\u0010\u0003\u0004\u00032\u0005\u0002\raV\u0001\u0006m\u0006dW/Z\u0001\foJLG/Z(cU\u0016\u001cG\u000fF\u0003p\u0005o\u0011I\u0004\u0003\u0004\u0003 \t\u0002\ra\u0018\u0005\u0007\u0005w\u0011\u0003\u0019A,\u0002\u0007=\u0014'.\u0001\u0005xe&$X-\u00138u)\u0015y'\u0011\tB#\u0011\u0019\u0011\u0019e\ta\u0001?\u0006\u0019q.\u001e;\t\u000f\tE2\u00051\u0001\u0002\"\u0005YqO]5uK\u0012{WO\u00197f)\u0015y'1\nB'\u0011\u0019\u0011\u0019\u0005\na\u0001?\"9!\u0011\u0007\u0013A\u0002\u00055\u0012\u0001D<sSR,'i\\8mK\u0006tG#B8\u0003T\tU\u0003B\u0002B\"K\u0001\u0007q\f\u0003\u0004\u00032\u0015\u0002\rAY\u0001\noJLG/\u001a#bi\u0016$Ra\u001cB.\u0005;BaAa\u0011'\u0001\u0004y\u0006b\u0002B\u0019M\u0001\u0007\u0011QM\u0001\noJLG/\u001a+j[\u0016$Ra\u001cB2\u0005KBaAa\u0011(\u0001\u0004y\u0006b\u0002B\u0019O\u0001\u0007!q\r\t\u0005\u0003O\u0012I'\u0003\u0003\u0003l\u0005%$\u0001\u0002+j[\u0016$Ra\u001cB8\u0005cBaAa\u0011)\u0001\u0004y\u0006b\u0002B\u0019Q\u0001\u0007\u0011qO\u0001\foJLG/Z*ue&tw\rF\u0003p\u0005o\u0012I\b\u0003\u0004\u0003D%\u0002\ra\u0018\u0005\b\u0005cI\u0003\u0019AA\u001d\u0003)9(/\u001b;f\u0005f$Xm\u001d\u000b\u0006_\n}$\u0011\u0011\u0005\u0007\u0005\u0007R\u0003\u0019A0\t\u000f\tE\"\u00061\u0001\u0002\u000e\u0005IqO]5uK*{%M\u001b\u000b\u0006_\n\u001d%\u0011\u0012\u0005\u0007\u0005\u0007Z\u0003\u0019A0\t\r\tE2\u00061\u0001X\u0003-9(/\u001b;f\u0013:$\u0018I\u001d:\u0015\u000b=\u0014yI!%\t\r\t\rC\u00061\u0001`\u0011\u001d\u0011\t\u0004\fa\u0001\u0003\u0017\u000bab\u001e:ji\u0016$u.\u001e2mK\u0006\u0013(\u000fF\u0003p\u0005/\u0013I\n\u0003\u0004\u0003D5\u0002\ra\u0018\u0005\b\u0005ci\u0003\u0019AAJ\u0003=9(/\u001b;f\u0005>|G.Z1o\u0003J\u0014H#B8\u0003 \n\u0005\u0006B\u0002B\"]\u0001\u0007q\fC\u0004\u000329\u0002\r!a'\u0002#]\u0014\u0018\u000e^3US6,7\u000f^1na\u0006\u0013(\u000fF\u0003p\u0005O\u0013I\u000b\u0003\u0004\u0003D=\u0002\ra\u0018\u0005\b\u0005cy\u0003\u0019AAr\u00039!\u0018.\\3ti\u0006l\u0007\u000fV8V)\u000e#B!a\u001e\u00030\"9!\u0011\u0017\u0019A\u0002\tM\u0016AB7jY2L7\u000fE\u0002;\u0005kK1Aa.<\u0005\u0011auN\\4\u0002\u0019]\u0014\u0018\u000e^3ECR,\u0017I\u001d:\u0015\u000b=\u0014iLa0\t\r\t\r\u0013\u00071\u0001`\u0011\u001d\u0011\t$\ra\u0001\u00037\fab\u001e:ji\u0016\u001cFO]5oO\u0006\u0013(\u000fF\u0003p\u0005\u000b\u00149\r\u0003\u0004\u0003DI\u0002\ra\u0018\u0005\b\u0005c\u0011\u0004\u0019AAR\u0003I9(/\u001b;f\r\u0006\u001cHo\u0015;sS:<\u0017I\u001d:\u0015\u000b=\u0014iMa4\t\r\t\r3\u00071\u0001`\u0011\u001d\u0011\td\ra\u0001\u0003G\u0003")
public class Serializer {
    private final JVMObjectTracker tracker;
    private Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe;

    public Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe() {
        return this.sqlSerDe;
    }

    public void sqlSerDe_$eq(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> x$1) {
        this.sqlSerDe = x$1;
    }

    public void registerSqlSerDe(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe) {
        this.sqlSerDe_$eq(sqlSerDe);
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType);
    }

    public Object readTypedObject(DataInputStream dis, char dataType) {
        Object object;
        char c = dataType;
        switch (c) {
            case 'n': {
                object = null;
                break;
            }
            case 'i': {
                object = new Integer(this.readInt(dis));
                break;
            }
            case 'd': {
                object = new Double(this.readDouble(dis));
                break;
            }
            case 'b': {
                object = new Boolean(this.readBoolean(dis));
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'a': {
                object = this.readArray(dis);
                break;
            }
            case 'l': {
                object = this.readList(dis);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'j': {
                object = this.tracker.getObject(this.readString(dis));
                break;
            }
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                Object obj = ((Function2)this.sqlSerDe()._1()).apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
                if (obj == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                object = obj;
                break;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        BoxedUnit bytesRead = BoxedUnit.UNIT;
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        String str = new String((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        int intVal = in.readInt();
        return intVal != 0;
    }

    public Date readDate(DataInputStream in) {
        return Date.valueOf(this.readString(in));
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$1 -> this.readBytes(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> this.readInt(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> this.readDouble(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> this.readBoolean(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$5 -> this.readString(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArrayArr(DataInputStream in) {
        int len = this.readInt(in);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$6 -> this.readArray(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
    }

    public Object readListArr(DataInputStream in) {
        int len = this.readInt(in);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$7 -> this.readList(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
    }

    public Date[] readDateArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Date[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$8 -> this.readDate(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Timestamp[] readTimeArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Timestamp[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$9 -> this.readTime(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public Object readArray(DataInputStream dis) {
        Object object;
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            case 'i': {
                object = this.readIntArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'j': {
                object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis))).map((Function1 & Serializable & scala.Serializable)x -> $this.tracker.getObject((String)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'a': {
                object = this.readArrayArr(dis);
                break;
            }
            case 'l': {
                object = this.readListArr(dis);
                break;
            }
            case 'D': {
                object = this.readDateArr(dis);
                break;
            }
            case 't': {
                object = this.readTimeArr(dis);
                break;
            }
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType).toString());
                }
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$10 -> Serializer.$anonfun$readArray$2(this, dis, arrType, BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
                break;
            }
        }
        return object;
    }

    public Object[] readList(DataInputStream dis) {
        int len = this.readInt(dis);
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$11 -> this.readObject(dis), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public scala.collection.immutable.Map<?, ?> readMap(DataInputStream in) {
        scala.collection.immutable.Map map;
        int len = this.readInt(in);
        if (len > 0) {
            Object keys = this.readArray(in);
            Object[] values = this.readList(in);
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(keys).zip((GenIterable)Predef$.MODULE$.wrapRefArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        String string = typeStr;
        if ("void".equals(string)) {
            dos.writeByte(110);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("character".equals(string)) {
            dos.writeByte(99);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("double".equals(string)) {
            dos.writeByte(100);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("integer".equals(string)) {
            dos.writeByte(105);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("logical".equals(string)) {
            dos.writeByte(98);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("date".equals(string)) {
            dos.writeByte(68);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("time".equals(string)) {
            dos.writeByte(116);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("raw".equals(string)) {
            dos.writeByte(114);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("array".equals(string)) {
            dos.writeByte(97);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("list".equals(string)) {
            dos.writeByte(108);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("map".equals(string)) {
            dos.writeByte(101);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("jobj".equals(string)) {
            dos.writeByte(106);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("strarray".equals(string)) {
            dos.writeByte(102);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("json".equals(string)) {
            dos.writeByte(74);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(typeStr).toString());
        }
    }

    private void writeKeyValue(DataOutputStream dos, Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid map key type: ").append(key.getClass().getName()).toString());
        }
        this.writeString(dos, (String)key);
        this.writeObject(dos, value);
    }

    public void writeObject(DataOutputStream dos, Object obj) {
        if (obj == null) {
            this.writeType(dos, "void");
        } else {
            Object value = obj instanceof WrappedArray ? ((WrappedArray)obj).toArray(ClassTag$.MODULE$.apply(Object.class)) : obj;
            Object object = value;
            if (object instanceof Character) {
                Character c = (Character)object;
                this.writeType(dos, "character");
                this.writeString(dos, c.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                this.writeType(dos, "character");
                this.writeString(dos, string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                Long l = (Long)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                Float f = (Float)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Float2float(f));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                Double d = (Double)object;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                Byte by = (Byte)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                Short s = (Short)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Short2short(s));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                this.writeType(dos, "logical");
                this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Date) {
                Date date = (Date)object;
                this.writeType(dos, "date");
                this.writeDate(dos, date);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Time) {
                Time time = (Time)object;
                this.writeType(dos, "time");
                this.writeTime(dos, time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                this.writeType(dos, "time");
                this.writeTime(dos, timestamp);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof StructTypeAsJSON) {
                StructTypeAsJSON structTypeAsJSON = (StructTypeAsJSON)object;
                this.writeType(dos, "json");
                this.writeString(dos, structTypeAsJSON.json());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof GenericRowWithSchema) {
                GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)object;
                this.writeType(dos, "list");
                this.writeInt(dos, genericRowWithSchema.length());
                genericRowWithSchema.toSeq().foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                this.writeType(dos, "raw");
                this.writeBytes(dos, byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                this.writeType(dos, "array");
                this.writeStringArr(dos, (String[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(cArray)).map((Function1 & Serializable & scala.Serializable)x$12 -> Serializer.$anonfun$writeObject$2(BoxesRunTime.unboxToChar((Object)x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, (int[])new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(sArray)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$13)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                this.writeType(dos, "array");
                this.writeIntArr(dos, nArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lArray)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$14 -> x$14, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(fArray)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$15 -> x$15, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, dArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                this.writeType(dos, "array");
                this.writeBooleanArr(dos, blArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Timestamp[]) {
                Timestamp[] timestampArray = (Timestamp[])object;
                this.writeType(dos, "array");
                this.writeTimestampArr(dos, timestampArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Date[]) {
                Date[] dateArray = (Date[])object;
                this.writeType(dos, "array");
                this.writeDateArr(dos, dateArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                this.writeType(dos, "strarray");
                this.writeFastStringArr(dos, stringArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.writeType(dos, "list");
                this.writeInt(dos, objectArray.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(objectArray)).foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)object;
                this.writeType(dos, "list");
                this.writeInt(dos, tuple3.productArity());
                tuple3.productIterator().foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Properties) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value2 = entry.getValue();
                    this.writeKeyValue(dos, key, value2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Serializer.$anonfun$writeObject$8(this, dos, x0$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.sqlSerDe() == null || this.sqlSerDe()._2() == null || !BoxesRunTime.unboxToBoolean((Object)((Function2)this.sqlSerDe()._2()).apply((Object)dos, value))) {
                    this.writeType(dos, "jobj");
                    this.writeJObj(dos, value);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        }
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        int intValue = value ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeString(out, value == null ? "" : value.toString());
    }

    public void writeTime(DataOutputStream out, Time value) {
        out.writeDouble(value == null ? Double.NaN : (double)value.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value) {
        out.writeDouble(value == null ? Double.NaN : (double)(value.getTime() / 1000L) + (double)value.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeJObj(DataOutputStream out, Object value) {
        String objId = this.tracker.put(value);
        this.writeString(out, objId);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> out.writeInt(v));
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(value)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> out.writeDouble(v));
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeBoolean(out, BoxesRunTime.unboxToBoolean((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeTime(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public Timestamp timestampToUTC(long millis) {
        long l = millis;
        Timestamp timestamp = 0L == l ? new Timestamp(0L) : new Timestamp(millis + (long)Calendar.getInstance().get(15) + (long)Calendar.getInstance().get(16));
        return timestamp;
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeTime(out, v == null ? null : this.timestampToUTC(v.getTime()));
            return BoxedUnit.UNIT;
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        this.writeType(out, "character");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeString(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeFastStringArr(DataOutputStream out, String[] value) {
        String all = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).mkString("\u0019");
        this.writeString(out, all);
    }

    public static final /* synthetic */ Object $anonfun$readArray$2(Serializer $this, DataInputStream dis$1, char arrType$1, int x$10) {
        Object obj = ((Function2)$this.sqlSerDe()._1()).apply((Object)dis$1, (Object)BoxesRunTime.boxToCharacter((char)arrType$1));
        if (obj == null) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType$1).toString());
        }
        return obj;
    }

    public static final /* synthetic */ String $anonfun$writeObject$2(char x$12) {
        return ((Object)BoxesRunTime.boxToCharacter((char)x$12)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeObject$8(Serializer $this, DataOutputStream dos$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        $this.writeKeyValue(dos$1, key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Serializer(JVMObjectTracker tracker) {
        this.tracker = tracker;
    }
}

