% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_persistence.R
\name{ml-persistence}
\alias{ml-persistence}
\alias{ml_save}
\alias{ml_save.ml_model}
\alias{ml_load}
\title{Spark ML -- Model Persistence}
\usage{
ml_save(x, path, overwrite = FALSE, ...)

\method{ml_save}{ml_model}(
  x,
  path,
  overwrite = FALSE,
  type = c("pipeline_model", "pipeline"),
  ...
)

ml_load(sc, path)
}
\arguments{
\item{x}{A ML object, which could be a \code{ml_pipeline_stage} or a \code{ml_model}}

\item{path}{The path where the object is to be serialized/deserialized.}

\item{overwrite}{Whether to overwrite the existing path, defaults to \code{FALSE}.}

\item{...}{Optional arguments; currently unused.}

\item{type}{Whether to save the pipeline model or the pipeline.}

\item{sc}{A Spark connection.}
}
\value{
\code{ml_save()} serializes a Spark object into a format that can be read back into \code{sparklyr} or by the Scala or PySpark APIs. When called on \code{ml_model} objects, i.e. those that were created via the \code{tbl_spark - formula} signature, the associated pipeline model is serialized. In other words, the saved model contains both the data processing (\code{RFormulaModel}) stage and the machine learning stage.

\code{ml_load()} reads a saved Spark object into \code{sparklyr}. It calls the correct Scala \code{load} method based on parsing the saved metadata. Note that a \code{PipelineModel} object saved from a sparklyr \code{ml_model} via \code{ml_save()} will be read back in as an \code{ml_pipeline_model}, rather than the \code{ml_model} object.
}
\description{
Save/load Spark ML objects
}
