% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscale.slice.R
\name{multiscale.slice}
\alias{multiscale.slice}
\title{Slicing a multi-scale density/intensity object}
\usage{
multiscale.slice(msob, h0, checkargs = TRUE)
}
\arguments{
\item{msob}{An object of class \code{\link{msden}} giving the multi-scale
estimate from which to take slices.}

\item{h0}{Desired global bandwidth(s); the density/intensity estimate
corresponding to which will be returned. A numeric vector. All values \bold{must} be in the
available range provided by \code{msob$h0range}; see `Details'.}

\item{checkargs}{Logical value indicating whether to check validity of
\code{msob} and \code{h0}. Disable only if you know this check will be
unnecessary.}
}
\value{
If \code{h0} is scalar, an object of class \code{\link{bivden}} with components
corresponding to the requested slice at \code{h0}. If \code{h0} is a vector, a list of objects
of class \code{\link{bivden}}.
}
\description{
Takes slices of a multi-scale density/intensity estimate at desired
global bandwidths
}
\details{
Davies & Baddeley (2018) demonstrate that once a multi-scale
density/intensity estimate has been computed, we may take slices parallel to
the spatial domain of the trivariate convolution to return the estimate at
any desired global bandwidth. This function is the implementation thereof
based on a multi-scale estimate resulting from a call to
\code{\link{multiscale.density}}.

The function returns an error if the
requested slices at \code{h0} are not all within the available range of
pre-computed global bandwidth scalings as defined by the \code{h0range}
component of \code{msob}.

Because the contents of the \code{msob} argument, an object of class
\code{\link{msden}}, are returned based on a discretised set of global
bandwidth scalings, the function internally computes the desired surface as
a pixel-by-pixel linear interpolation using the two discretised global
bandwidth rescalings that bound each requested \code{h0}. (Thus, numeric
accuracy of the slices is improved with an increase to the \code{dimz}
argument of the preceding call to \code{multiscale.density} at the cost of
additional computing time.)
}
\examples{
\dontrun{
data(chorley) # Chorley-Ribble data (package 'spatstat')
ch.multi <- multiscale.density(chorley,h0=1,h0fac=c(0.5,2))

available.h0(ch.multi)
ch.slices <- multiscale.slice(ch.multi,h0=c(0.7,1.1,1.6))

par(mfcol=c(2,3)) # plot each density and edge-correction surface
for(i in 1:3) { plot(ch.slices[[i]]$z); plot(ch.slices[[i]]$q) }
}

}
\references{
Davies, T.M. and Baddeley A. (2018), Fast computation of
spatially adaptive kernel estimates, \emph{Statistics and Computing}, [to appear].
}
\seealso{
\code{\link{multiscale.density}}, \code{\link{bivariate.density}}
}
\author{
T.M. Davies
}
