% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateVAR.R
\name{estimateVAR}
\alias{estimateVAR}
\title{Multivariate VAR estimation}
\usage{
estimateVAR(data, p = 1, penalty = "ENET", options = NULL)
}
\arguments{
\item{data}{the data from the time series: variables in columns and observations in 
rows}

\item{p}{order of the VAR model}

\item{penalty}{the penalty function to use. Possible values are \code{"ENET"}, 
\code{"SCAD"} or \code{"MCP"}}

\item{options}{list of options for the function. Global options are:
\code{threshold}: \code{TRUE} or \code{FALSE}. If \code{TRUE} all the entries smaller 
than the oracle threshold are set to zero. \code{scale} scale the data?}
}
\value{
A the list (of length \code{p}) of the estimated matrices of the process

fit the results of the penalized LS estimation

mse the mean square error of the cross validation

time elapsed time for the estimation
}
\description{
A function to estimate a (possibly high-dimensional) multivariate VAR time series
using penalized least squares methods, such as ENET, SCAD or MC+.
}

