% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_lag.R
\name{sparse_lag}
\alias{sparse_lag}
\title{Compute lagged values for sparse vectors}
\usage{
sparse_lag(x, n = 1L, default = NULL)
}
\arguments{
\item{x}{A sparse vector.}

\item{n}{Positive integer of length 1, giving the number of positions to lag
by.}

\item{default}{The value used to pad \verb{x`` back to its original size after the lag has been applied. The default, }NULL``, pads with a missing value.}
}
\value{
sparse vector.
}
\description{
Compute lagged values for sparse vectors
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.
}
\examples{
vec_dbl <- sparse_double(c(pi, 4, 5/2), c(1, 5, 7), 10)

sparse_lag(vec_dbl)
sparse_lag(vec_dbl, n = 3)
sparse_lag(vec_dbl, n = 3, default = 0)

vec_int <- sparse_integer(c(1, 2, 3), c(1, 5, 7), 10)

sparse_lag(vec_int)
sparse_lag(vec_int, n = 3)
sparse_lag(vec_int, n = 3, default = 0L)

vec_chr <- sparse_character(c("A", "B", "C"), c(1, 5, 7), 10)

sparse_lag(vec_chr)
sparse_lag(vec_chr, n = 3)
sparse_lag(vec_chr, n = 3, default = "before")

vec_lgl <- sparse_logical(c(TRUE, TRUE, TRUE), c(1, 5, 7), 10)

sparse_lag(vec_lgl)
sparse_lag(vec_lgl, n = 3)
sparse_lag(vec_lgl, n = 3, default = FALSE)
}
