aa_summariseReplicateRuns<-function(FILEPATH,SAMPLESIZES,MEASURES,RESULTFILENAME,ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,SUMMARYFILENAME,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	if(is.null(TIMEPOINTS))
	{
		SAMPLE_SIZE_RESULTS<-NULL

		for(SAMPLESIZE in 1:length(SAMPLESIZES))
		{
			for(SET in 1:20)
			{
				print(paste("Processing Sample Size ",SAMPLESIZES[SAMPLESIZE]," Set ",SET,sep=""))

				SAMPLE_FILEPATH<-paste(FILEPATH,"/",SAMPLESIZES[SAMPLESIZE],"/",SET,"/",sep="")
	
				MEDIANS<-data.frame(getMediansSubset(SAMPLE_FILEPATH,SAMPLESIZES[SAMPLESIZE],MEASURES,RESULTFILENAME,
							ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND))

				if(nrow(MEDIANS)>0)
				{

					# NOW TO TAKE THE MEDIAN OF THE MEDIANS FOR THIS SET OF RUNS
					#SET_RESULT<-cbind(array(SAMPLESIZES[SAMPLESIZE],dim=nrow()),array(SET,dim=nrow(RESULT)))
					SET_RESULT<-cbind(SAMPLESIZES[SAMPLESIZE],SET)
					for(MEASURE in 1:length(MEASURES))
					{
						SET_RESULT<-cbind(SET_RESULT,median(MEDIANS[[MEASURES[MEASURE]]],na.rm = TRUE))
					}

					SAMPLE_SIZE_RESULTS<-rbind(SAMPLE_SIZE_RESULTS,SET_RESULT)
				}		
			}
		}

		colnames(SAMPLE_SIZE_RESULTS)<-c("SampleSize","Set",MEASURES)

		RESULTSFILE = paste(FILEPATH,"/",SUMMARYFILENAME,sep="")
		print(paste("Writing Median Results to CSV File: ",RESULTSFILE,sep=""))
		write.csv(SAMPLE_SIZE_RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
	}
	else
	{
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			RESULTFILEFORMAT<-substr(RESULTFILENAME,(nchar(RESULTFILENAME)+1)-3,nchar(RESULTFILENAME))
			SIMRESULTFILENAME<-paste(substr(RESULTFILENAME,0,nchar(RESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
		
			if(!is.null(ALTFILENAME))
			{
				ALTFILENAMEFULL<-paste(substr(ALTFILENAME,0,nchar(ALTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
			}
			else
			{
				ALTFILENAMEFULL<-ALTERNATIVEFILENAME
			}

			SUMMARYFILENAME_FORMAT<-substr(SUMMARYFILENAME,(nchar(SUMMARYFILENAME)+1)-3,nchar(SUMMARYFILENAME))
			SUMMARYFILENAME_FULL<-paste(substr(SUMMARYFILENAME,0,nchar(SUMMARYFILENAME)-4),"_",TIMEPOINTPROCESSING,".",SUMMARYFILENAME_FORMAT,sep="")


			aa_summariseReplicateRuns(FILEPATH,SAMPLESIZES,MEASURES,SIMRESULTFILENAME,ALTFILENAMEFULL,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
							SUMMARYFILENAME_FULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)

		}
	}
}
