% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_evolution.R
\name{set.nsga_sensitivity_params}
\alias{set.nsga_sensitivity_params}
\title{Set parameters for NSGA-2 sensitivity analysis}
\usage{
set.nsga_sensitivity_params(generation_min, crossover_min, mutation_min,
  generation_max, crossover_max, mutation_max, seed)
}
\arguments{
\item{generation_min}{Minimum value for number of generations}

\item{crossover_min}{Minimum value for crossover}

\item{mutation_min}{Minimum value for mutation rate}

\item{generation_max}{Maximum value for number of generations}

\item{crossover_max}{Maximum value for crossover}

\item{mutation_max}{Maximum value for mutation rate}

\item{seed}{Random seed value to use in the algorithm}
}
\value{
List of the above, for passing in as a settings object to NSGA-2
related methods
}
\description{
Establish the parameters for the NSGA-2 sensitivity analysis, creating an
object that is used within the method that screens NSGA-2 parameters.
}
