% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\alias{simulate-spatPomp}
\alias{simulate,spatPomp-method}
\title{Simulation of a spatiotemporal partially-observed Markov process}
\usage{
\S4method{simulate}{spatPomp}(
  object,
  nsim = 1,
  seed = NULL,
  format = c("spatPomps", "data.frame"),
  include.data = FALSE,
  ...
)
}
\arguments{
\item{object}{optional; if present, it should be the output of one of \pkg{pomp}'s methods}

\item{nsim}{number of simulations.}

\item{seed}{optional;
if set, the pseudorandom number generator (RNG) will be initialized with \code{seed}.  the random seed to use.
The RNG will be restored to its original state afterward.}

\item{format}{the format of the simulated results. If the argument is
set to \code{'spatPomps'}, the default behavior, then the output is a
\code{list} of \code{spatPomp} objects. Options are \code{'spatPomps'}
and \code{'data.frame'}.}

\item{include.data}{if \code{TRUE}, the original data are included (with \code{.id = "rep"}).
This option is ignored unless \code{format = "data.frame"}.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link[pomp]{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link[pomp]{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[pomp:userdata]{?userdata} for information on how to use this facility.}
}
\value{
if \code{format='spatPomps'} and \code{nsim=1} an object of class \sQuote{spatPomp} representing a simulation from the model in \code{object} is returned.
If \code{format='spatPomps'} and \code{nsim>1} a list of class \sQuote{spatPomp} objects is returned.
If \code{format='data.frame'} then a class \sQuote{data.frame} object is returned.
}
\description{
\code{simulate} generates simulations of the latent and measurement
processes.
}
\examples{
# Get a spatPomp object
b <- bm(U=5, N=10)
# Get 10 simulations from same model as data.frame
sims <- simulate(b, nsim=10, format='data.frame')
}
