% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgwc.R
\name{fgwc}
\alias{fgwc}
\title{Fuzzy Geographically Weighted Clustering (FGWC)}
\usage{
fgwc(X, population, distance, K = 2, m = 2, beta = 0.5, a = 1, b = 1,
  max.iteration = 100, threshold = 10^-5, RandomNumber = 0)
}
\arguments{
\item{X}{data frame n x p}

\item{population}{dataset 1 x n number of population each region (row)}

\item{distance}{shapefile or distance matrik n x n}

\item{K}{specific number of cluster (must be >1)}

\item{m}{fuzzifier / degree of fuzziness}

\item{beta}{proportion of geographically effect (if 0 equal Fuzzy C-Means)}

\item{a}{power for increase population effect}

\item{b}{power for increase distance effect}

\item{max.iteration}{maximum iteration to convergence}

\item{threshold}{threshold of convergence}

\item{RandomNumber}{specific seed}
}
\value{
func.obj objective function that calculated.

U matrix n x K consist fuzzy membership matrix

V matrix K x p consist fuzzy centroid

D matrix n x K consist distance of data to centroid that calculated

Clust.desc cluster description (dataset with additional column of cluster label)
}
\description{
This function used to perform Fuzzy Geographically Weighted Clustering of X dataset.
}
\details{
This function perform Fuzzy Geographically Weighted Clustering by G.A Mason and R.Jacobson (2007).
Fuzzy Geographically Weighted Clustering is one of fuzzy clustering methods to clustering dataset
become K cluster. Number of cluster (K) must be greater than 1. To control the overlaping
or fuzziness of clustering, parameter m must be specified.
Maximum iteration and threshold is specific number for convergencing the cluster.
Random Number is number that will be used for seeding to firstly generate fuzzy membership matrix.
population dataset, shapefile or distance matrix is used to give geographically weighted for membership matrix.

Clustering will produce fuzzy membership matrix (U) and fuzzy cluster centroid (V).
The greatest value of membership on data point will determine cluster label.
Centroid or cluster center can be use to interpret the cluster. Both membership and centroid produced by
calculating mathematical distance. Fuzzy Geographically Weighted Clustering calculate distance with Euclideans norm. So it can be said that cluster
will have sperichal shape of geometry.
}
\examples{
#load data example
X <- example

#if using matrix distance
distance <- dist

#if using shapefile
#library(rgdal) for call readOGR
#distance <- readOGR(dsn = 'folder/.',"shapefile name")

#load population data
pop <- population

clust <- fgwc(X,pop,distance,K=2,m=1.5,beta=0.5)

}
\references{
G. A. Mason and R. D. Jacobson.(2007). Fuzzy Geographically Weighted Clustering, in Proceedings of the 9th International Conference on Geocomputation, no. 1998, pp. 1-7

Bezdek, J. C., Ehrlich, R., & Full, W. (1984). FCM: The Fuzzy C-Means Clustering Algorithm. Computers and Geosciences Vol 10, 191-203
}
\seealso{
\code{\link{fgwc.gsa}} for optimize using Gravitational Search Algorithm,
\code{\link{spClustIndex}} for cluser validation,
\code{\link{visualize}} for cluster visualizatiion
}

