% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexagons.R
\name{hexagons}
\alias{hexagons}
\title{Hexagons}
\usage{
hexagons(x, res = 100, ...)
}
\arguments{
\item{x}{sp SpatialDataFrame class object}

\item{res}{Area of resulting hexagons}

\item{...}{Additional arguments passed to spsample}
}
\value{
SpatialPolygonsDataFrame OBJECT
}
\description{
Create hexagon polygons
}
\note{
depends: sp
}
\examples{
require(sp)
  data(meuse)
    coordinates(meuse) <- ~x+y 

hex.polys <- hexagons(meuse, res=100)   
  plot(hex.polys)
    plot(meuse,pch=20,add=TRUE)

# Points intersecting hexagons  
hex.pts <- na.omit(over(meuse,hex.polys))
(hex.pts <- data.frame(PTID=rownames(hex.pts), hex.pts)) 

}

