% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobel.R
\name{sobal}
\alias{sobal}
\title{Sobel-Feldman operator}
\usage{
sobal(x, method = "intensity", ...)
}
\arguments{
\item{x}{A raster class object}

\item{method}{Type of operator ("intensity", "direction", "edge")}

\item{...}{Additional arguments passed to raster::overlay or, 
if method="edge", raster::focal (if you want a file 
 written to disk use filename = "" argument)}
}
\value{
A raster class object or raster written to disk
}
\description{
An isotropic image gradient operator using a 3x3 window

The Sobel-Feldmanh operator is a discrete differentiation operator, deriving an 
approximation of the gradient of the intensity function. abrupt discontinuity 
in the gradient function represents edges, making this a common approach for edge 
detection. The Sobel-Feldman operator is based on convolving the image with a small, 
separable, and integer matrix in the horizontal and vertical directions. The operator 
uses two 3x3 kernels which are convolved with the original image to calculate 
approximations of the derivatives - one for horizontal changes, and one for vertical. 
Where x is defined here as increasing in the right-direction, and y as increasing in 
the down-direction. At each pixel in the raster, the resulting gradient can be combined 
to give the gradient intensity, using: SQRT( Gx^2 Gy^2 ). This can be expanded into the 
gradient direction using atan(Gx/Gy)
}
\examples{
library(raster)
r <- brick(system.file("external/rlogo.grd", package="raster")) 
s.int <- sobal(r[[1]])
s.dir <- sobal(r[[1]], method = "direction")
s.edge <- sobal(r[[1]], method = "edge")
par(mfrow=c(2,2))
  plot(r[[1]])
  plot(s.int, main="intensity") 
  plot(s.dir, main="direction") 
  plot(s.edge, main="edge")
  
}
\references{
Sobel, I., & G. Feldman, (1969) A 3x3 Isotropic Gradient Operator for Image Processing, 
  presented at the Stanford Artificial Intelligence Project (SAIL).
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
