% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterDistance.R
\name{rasterDistance}
\alias{rasterDistance}
\title{Raster Distance}
\usage{
rasterDistance(x, y, reference = NULL, scale = FALSE)
}
\arguments{
\item{x}{rasterLayer, sp SpatialPoints or sf POINTS object}

\item{y}{sp SpatialPoints or sf POINTS object}

\item{reference}{A raster to use as a reference if x is points object}

\item{scale}{(FALSE/TRUE) Perform a row standardization on results}
}
\value{
a distance raster of class rasterLayer
}
\description{
Calculates the Euclidean distance between a set of points and
             the cells in a raster. This is a drop-in replacement for the  
             raster distanceFromPoints function using the RANN algorithm for 
             calculating distance, resulting in a large improvement in   
             processing speed.
}
\note{
This replicates the raster distanceFromPoints function but uses the Arya & Mount
Approximate Near Neighbor (ANN) C++ library for calculating distances. Where this
results in a notable increase in performance it is not memory safe, needing to read
in the entire raster and does not use the GeographicLib (Karney, 2013) spheroid 
distance method for geographic data.
}
\examples{
library(raster)
r <- raster(ncol=100,nrow=100)
  r[] <- sample(c(0,1), ncell(r), replace = TRUE)
 
majority <- function(x){
 m <- table(x)
 names(m)[which.max(m)][1]
}
r <- focal(r, matrix(1,11,11, byrow=TRUE), majority) 
 
 pts <- rasterToPoints(r, spatial=TRUE)
   cls <- pts[pts$layer == "1",] 
 d <- rasterDistance(pts, cls, reference = r, scale=TRUE)
   dev.new(height=8,width=11)
     plot(d)
       points(cls,pch=19,cex=0.5)

}
\references{
Arya S., Mount D. M., Netanyahu N. S., Silverman R. and Wu A. Y (1998), An 
  optimal algorithm for approximate nearest neighbor searching, Journal of 
  the ACM, 45, 891-923.
}
\seealso{
\code{\link[raster]{distanceFromPoints}, \link[raster]{distance}}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
