% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudobulk_samples.R
\name{pseudobulk_dim_plot}
\alias{pseudobulk_dim_plot}
\title{pseudobulk_dim_plot: Plot PCA of pseudobulk samples}
\usage{
pseudobulk_dim_plot(
  x = NULL,
  color_pal = "muted",
  plot_meta = NULL,
  dim = "pca",
  pcx = 1,
  pcy = 2,
  ptsize = 5
)
}
\arguments{
\item{x}{an STlist with pseudobulk PCA results in the \verb{@misc} slot (generated by
\code{pseudobulk_samples})}

\item{color_pal}{a string of a color palette from khroma or RColorBrewer, or a
vector of color names or HEX values. Each color represents a category in the
variable specified in \code{plot_meta}}

\item{plot_meta}{a string indicating the name of the variable in the sample
metadata to color points in the PCA plot}

\item{dim}{one of \code{umap} or \code{pca}. The dimension reduction to plot}

\item{pcx}{integer indicating the principal component to plot in the x axis}

\item{pcy}{integer indicating the principal component to plot in the y axis}

\item{ptsize}{the size of the points in the PCA plot. Passed to the \code{size}
aesthetic from \code{ggplot2}}
}
\value{
a ggplot object
}
\description{
Generates a PCA plot after computation of "pseudobulk" counts
}
\details{
Generates a Principal Components Analysis plot to help in initial data exploration of
differences among samples. The points in the plot represent "pseudobulk" samples.
This function follows after usage of \code{pseudobulk_samples}.
}
\examples{
\donttest{
# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
unzip(zipfile=zip_tmp, exdir=thrane_tmp)
# Generate the file paths to be passed to the STlist function
count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='counts')
coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='mapping')
clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                        full.names=TRUE, pattern='clinical')
# Create STlist
library('spatialGE')
melanoma <- STlist(rnacounts=count_files,
                   spotcoords=coord_files,
                   samples=clin_file, cores=2)
melanoma <- pseudobulk_samples(melanoma)
pseudobulk_dim_plot(melanoma, plot_meta='patient')
}

}
