% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{bi_NN_G}
\alias{bi_NN_G}
\title{Bivariate Nearest Neighbor Based Measures of Spatial Clustering for IF data}
\usage{
bi_NN_G(
  mif,
  mnames,
  r_range = seq(0, 100, 50),
  num_permutations = 50,
  edge_correction = "rs",
  keep_perm_dis = FALSE,
  exhaustive = TRUE,
  workers = 1,
  overwrite = FALSE
)
}
\arguments{
\item{mif}{An MIF object}

\item{mnames}{Character vector of marker names to estimate degree of
nearest neighbor distribution}

\item{r_range}{Numeric vector of potential r values this range must include 0.
Note that the range selected is very different than count based measures.
See details.}

\item{num_permutations}{Numeric value indicating the number of permutations used.
Default is 50.}

\item{edge_correction}{Character value indicating the type of edge correction
to use. Options include "rs" or "hans".}

\item{keep_perm_dis}{Logical value determining whether or not to keep the full
distribution of permuted G values}

\item{exhaustive}{Logical. If TRUE then markers must be a vector and spatial
measures will be computed all pairs of unique markers. If FALSE then markers must
be a data.frame with the desired combinations.}

\item{workers}{Integer value for the number of workers to spawn}

\item{overwrite}{Logical value determining if you want the results to replace the
current output (TRUE) or be to be appended (FALSE).}
}
\value{
Returns a data frame
\item{anchor}{Marker for which the distances are measured from}
\item{counted}{Marker for which the distances are measured to}
\item{Theoretical CSR}{Expected value assuming complete spatial randomness}
\item{Permuted CSR}{Average observed G for the permuted point
process}
\item{Observed}{Observed value for the observed point process}
\item{Degree of Clustering Permuted}{Degree of spatial clustering where the
reference is the permuted estimate of CSR}
\item{Degree of Clustering Theoretical}{Degree of spatial clustering where the
reference is the theoretical estimate of CSR}
}
\description{
This function computes the nearest neighbor distribution for a
particular marker relative to another marker for the observed and permuted point
processes.
}
