% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points_in_circle.R
\name{points_in_circle}
\alias{points_in_circle}
\title{Points in circle}
\usage{
points_in_circle(
  data,
  lon_center,
  lat_center,
  lon = lon,
  lat = lat,
  radius = 200
)
}
\arguments{
\item{data}{A data.frame.}

\item{lon_center}{Longitude of center point.}

\item{lat_center}{Latitude of center point.}

\item{lon}{Name of column in \code{data} with longitudes (lon is default).}

\item{lat}{Name of column in \code{data} with latitudes (lat is default).}

\item{radius}{Radius (in meters) (default is 200m).}
}
\value{
A data.frame of coordinates within \code{radius} around \code{(lon_center, lat_center)}. The column \code{distance_m} gives the distance from the center point (in meters).
}
\description{
The observations within radius from the center point.
}
\examples{
points_in_circle(Groningen, lon_center = 6.571561, lat_center = 53.21326, radius = 50)

}
\author{
Martin Haringa
}
