#
#
#  defaultwin.R
#
#   $Revision: 1.7 $   $Date: 2011/10/13 01:51:36 $
#

default.expand <- function(object, m=2, epsilon=1e-6) {
  verifyclass(object, "ppm")
  # no expansion necessary if model is Poisson
  if(is.poisson(object))
    return(1)
  # no expansion if model depends on covariate data
  if(summary(object)$uses.covars)
    return(1)
  # expand data window by distance d = m * reach
  w <- as.owin(data.ppm(object))
  rr <- reach(object, epsilon=epsilon)
  if(!is.finite(rr))
    return(NULL)
  if(!is.numeric(m) || length(m) != 1 || m < 1)
    stop("m should be a single number >= 1")
  mr <- m * rr
  if(w$type == "rectangle") 
    return(owin(w$xrange + c(-1,1) * mr, w$yrange + c(-1,1) * mr))
  else
    return(dilation.owin(w, mr))
}

default.clipwindow <- function(object, epsilon=1e-6) {
  verifyclass(object, "ppm")
  # data window
  w <- as.owin(data.ppm(object))
  # interaction range of model
  rr <- reach(object, epsilon=epsilon)
  if(!is.finite(rr))
    return(NULL)
  if(rr == 0)
    return(w)
  else
    return(erosion.owin(w, rr))
}

  
