if(dev.cur() <= 1) {
  dd <- getOption("device")
  if(is.character(dd)) dd <- get(dd)
  dd()
}

oldpar <- par(ask = interactive() && dev.interactive(orNone=TRUE))
oldoptions <- options(warn=-1)

plot(amacrine)

plot(anemones, markscale=0.5)

ants.extra$plot()

plot(bei.extra$elev, main="Beilschmiedia")
plot(bei, add=TRUE, pch=16, cex=0.3)

plot(betacells)

plot(bramblecanes, cols=1:3)
plot(split(bramblecanes))

plot(bronzefilter,markscale=1)

plot(cells)

plot(as.linnet(chicago), main="Chicago Street Crimes",col="green")
plot(as.ppp(chicago), add=TRUE, col="red", chars=c(16,2,22,17,24,15,6))

chorley.extra$plotit()

plot(copper$Points, main="Copper")
plot(copper$Lines, add=TRUE)

plot(demopat)

plot(finpines, which.marks="diameter", main="Finnish pines (diameter)")
plot(finpines, which.marks="height", main="Finnish pines (height)")

wildM1 <- with(flu, virustype == "wt" & stain == "M2-M1")
plot(flu[wildM1, 1, drop=TRUE],
     main=c("flu data", "wild type virus, M2-M1 stain"),
     chars=c(16,3), cex=0.4, cols=2:3)

plot(gorillas, chars=c(1,3), cols=2:3, main="Gorilla nest sites")

plot(hamster, cols=c(2,4))

plot(heather)

plot(humberside)

plot(japanesepines)

plot(lansing)
plot(split(lansing))

plot(longleaf)

plot(murchison$greenstone, main="Murchison data", col="lightgreen")
plot(murchison$gold, add=TRUE, pch="+",col="blue")
plot(murchison$faults, add=TRUE, col="red")

plot(nbfires, use.marks=FALSE, pch=".")
plot(split(nbfires), chars=".")
a <- plot(split(nbfires)$"2000", which.marks="fire.type",
          main=c("New Brunswick fires 2000", "by fire type"),
          cols=c("red", "blue", "green", "cyan"))
legend("bottomleft", title="Fire type",
       legend=names(a), pch=a, col=c("red", "blue", "green", "cyan"))

plot(nztrees)

enable3d <- ("scatterplot3d" %in% row.names(installed.packages()))
if(enable3d) {
  plot(osteo[1:10,], tick.marks=FALSE, xlab="", ylab="", zlab="")
}

ponderosa.extra$plotit()

plot(redwood)

redwoodfull.extra$plot()

plot(residualspaper$Fig1)
plot(residualspaper$Fig4a)
plot(residualspaper$Fig4b)
plot(residualspaper$Fig4c)

shapley.extra$plotit(main="Shapley")

plot(simdat)

plot(spruces, maxsize=min(nndist(spruces))/2)

plot(swedishpines)

a <- plot(urkiola, cex=0.5, cols=2:3)
legend("bottomleft", legend=names(a), pch=a, col=2:3)
par(oldpar)
options(oldoptions)
