% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAS.R
\name{getBASSample}
\alias{getBASSample}
\title{Generate the BAS sample.}
\usage{
getBASSample(shapefile, bb, n, seeds, boxes = NULL)
}
\arguments{
\item{shapefile}{Shape file as a polygon (sp or sf) to select sites for.}

\item{bb}{Bounding box which defines the area around the study area. A bounding box must be
supplied.}

\item{n}{Number of sites to select. If using stratification it is a named vector containing
sample sizes of each group.}

\item{seeds}{A vector of 2 seeds, u1 and u2. seeds must have a value when this function is called.}

\item{boxes}{A vector of integers for which points along the Halton random starting point to sample from.}
}
\value{
A list containing two variables, \code{$sample} containing locations in the BAS sample,
in BAS order and \code{$seeds}, the u1 and u2 seeds used to generate the sample.
}
\description{
This function is repeatedly called from function spbal::getBASSampleDriver
to generate a BAS sample.
}
\author{
This function was written by Phil Davies.
}
\keyword{internal}
