% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{controlExtractor}
\alias{controlExtractor}
\title{Extracts the control variable names and coefficients from a model summary.}
\usage{
controlExtractor(model, x)
}
\arguments{
\item{model}{A model summary object.}

\item{x}{A string containing the independent variable name.}
}
\value{
A dataframe with two columns, `term` contains the name of the control
        and `coef` contains the coefficient estimate.
}
\description{
Extracts the control variable names and coefficients from a model summary.
}
\examples{
m <- summary(lm(Salnty ~ STheta + T_degC, bottles))
controlExtractor(model = m, x = "STheta");

m <- summary(lm(Salnty ~ STheta*T_degC + O2Sat, bottles))
controlExtractor(model = m, x = "STheta");
}
