% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpectraDataFrame-methods.R
\docType{methods}
\name{features}
\alias{features}
\alias{features<-}
\alias{features-methods}
\alias{features,SpectraDataFrame-method}
\alias{features<-,Spectra-method}
\alias{features<-,SpectraDataFrame-method}
\title{Retrieves or sets the data slot of a SpectraDataFrame object.}
\usage{
\S4method{features}{SpectraDataFrame}(object,exclude_id)
\S4method{features}{Spectra}(object,safe,exclude_id,key,append) <- value
}
\arguments{
\item{object}{a \code{Spectra} object}

\item{exclude_id}{see below}

\item{value}{see below}

\item{safe}{see below}

\item{key}{see below}

\item{append}{see below}
}
\value{
The \code{features} methods return a \code{data.frame} object, while
the \code{"features<-"} methods return a \code{SpectraDataFrame} object.
}
\description{
Either retrieves the attributes values from the data slot of a
SpectraDataFrame object, or upgrades a Spectra object to a SpectraDataFrame
object by initialising its data slot by a suitable \code{"data.frame"}
object.
}
\section{Methods}{
 \describe{

\bold{x=Spectra}

\code{features(object, safe=TRUE, key=NULL, exclude_id=TRUE) <- value}

\tabular{rll}{ \tab \code{object} \tab A \code{Spectra} object \cr \tab
\code{safe} \tab Logical. If TRUE, data is being added to the object using a
SQL join (using a key field given by the \code{key} option), otherwise it is
assumed the order of the rows is consitent with the order of the rows in
\code{object} \cr \tab \code{key} \tab Character, name of the column of the
data.frame storing the ids for the SQL join. Ignored if \code{safe} is
\code{FALSE}. \cr \tab \code{exclude_id} \tab Logical, if \code{TRUE}, ids
used for the SQL join are removed from the data slot after the join. \cr }

\bold{x=SpectraDataFrame}

\code{features(obj, exclude_id=TRUE)}

\code{features(obj, safe=TRUE, key=NULL, exclude_id=TRUE, append=TRUE) <-
value}

\tabular{rll}{ \tab \code{object} \tab A \code{SpectraDataFrame} object \cr
\tab \code{safe} \tab Logical. If TRUE, data is being added to the object
using a SQL join (using a key field given by the \code{key} option),
otherwise it is assumed the order of the rows is consitent with the order of
the rows in \code{object} \cr \tab \code{key} \tab Character, name of the
column of the data.frame storing the ids for the SQL join. Ignored if
\code{safe} is \code{FALSE}. \cr \tab \code{exclude_id} \tab Logical. For
the \code{features} method, if \code{TRUE}, the spectra ids are added to the
\code{data.frame} that is returned. For the \code{"features<-"} method, If
\code{TRUE}, ids used for the SQL join are removed from the data slot after
the join. \cr \tab \code{append} \tab Logical, if \code{TRUE}, the data is
appended to any existing data. if FALSE, the data provided is erasing any
existing data. \cr }

}
}

\examples{

# Loading example data
data(oz)
spectra(oz) <- sr_no ~ ... ~ 350:2500

# Printing available data
features(oz)

# Promoting a Spectra to a SpectraDataFrame object
s <- as(oz, "Spectra")

# Generating dummy data
d <- data.frame(
  id = ids(oz), 
  foo = runif(nrow(oz)), 
  bar = sample(LETTERS[1:5], size = nrow(oz), replace = TRUE)
)
head(d)

# Affecting data to Spectra object
features(s, key = 'id') <- d

# Adding data to an existing SpectraDataFrame object
features(oz, key = 'id') <- d
features(oz)

# Replacing data of an existing SpectraDataFrame object
features(oz, key = 'id', append = FALSE) <- d
features(oz)

}
\seealso{
\code{\link{spectra}}, \code{\link{wl}},
\code{\link{SpectraDataFrame-class}}
}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
