% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R
\docType{methods}
\name{wl_units}
\alias{wl_units}
\alias{wl_units<-}
\alias{wl_units,Spectra-method}
\alias{wl_units<-,Spectra-method}
\alias{wl_units<-,Spectra-method}
\title{Wavelengths of Spectra* objects}
\usage{
wl_units(object)

\S4method{wl_units}{Spectra}(object) <- value
}
\arguments{
\item{object}{an object inheriting from class \code{Spectra}}

\item{value}{a character string}
}
\value{
A vector
}
\description{
Retrieves the wavelengths units from \code{Spectra*} object
}
\examples{
# Loading example data
data(oz)
spectra(oz) <- sr_no ~ ... ~ 350:2500

# Print wavelength information
wl(oz)
range(wl(oz))

# Manipulate wavelength information
wl(oz) <- wl(oz) + 1000
wl(oz)

}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
