## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = 'center',
  fig.height = 5,
  fig.width = 5
)

## ----libs---------------------------------------------------------------------
library(spectacles)

## ----australia----------------------------------------------------------------
data("australia")
class(australia)
big.head(australia)

## ----conversion---------------------------------------------------------------
spectra(australia) <- sr_no ~ ... ~ 350:2500
summary(australia)

## -----------------------------------------------------------------------------
nrow(australia)

## -----------------------------------------------------------------------------
ncol(australia)

## -----------------------------------------------------------------------------
length(australia)

## -----------------------------------------------------------------------------
dim(australia)

## -----------------------------------------------------------------------------
sub <- australia[1:5,]
summary(sub)

## -----------------------------------------------------------------------------
# Just printing the first 5
ids(australia)[1:5]

## -----------------------------------------------------------------------------
# Just printing the first 10
wl(australia)[1:10]

## -----------------------------------------------------------------------------
s <- spectra(australia)
class(s)
dim(s)
big.head(s)

## -----------------------------------------------------------------------------
wl_units(australia)

## -----------------------------------------------------------------------------
df <- features(australia)
class(df)
head(df)

## ----plot-1-------------------------------------------------------------------
plot(australia)

## ----plot-2-------------------------------------------------------------------
plot(australia, col = "royalblue")

