% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphLaplacianEstimation.R
\name{learn_laplacian_gle_admm}
\alias{learn_laplacian_gle_admm}
\title{Learn the weighted Laplacian matrix of a graph using the ADMM method}
\usage{
learn_laplacian_gle_admm(
  S,
  A_mask = NULL,
  alpha = 0,
  rho = 1,
  maxiter = 10000,
  reltol = 1e-05,
  record_objective = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{S}{a pxp sample covariance/correlation matrix}

\item{A_mask}{the binary adjacency matrix of the graph}

\item{alpha}{L1 regularization hyperparameter}

\item{rho}{ADMM convergence rate hyperparameter}

\item{maxiter}{the maximum number of iterations}

\item{reltol}{relative tolerance on the Laplacian matrix estimation}

\item{record_objective}{whether or not to record the objective function. Default is FALSE}

\item{verbose}{if TRUE, then a progress bar will be displayed in the console. Default is TRUE}
}
\value{
A list containing possibly the following elements:
\item{\code{Laplacian}}{the estimated Laplacian Matrix}
\item{\code{Adjacency}}{the estimated Adjacency Matrix}
\item{\code{convergence}}{boolean flag to indicate whether or not the optimization converged}
\item{\code{obj_fun}}{values of the objective function at every iteration in case record_objective = TRUE}
}
\description{
Learn the weighted Laplacian matrix of a graph using the ADMM method
}
\references{
Licheng Zhao, Yiwei Wang, Sandeep Kumar, and Daniel P. Palomar.
            Optimization Algorithms for Graph Laplacian Estimation via ADMM and MM.
            IEEE Trans. on Signal Processing, vol. 67, no. 16, pp. 4231-4244, Aug. 2019
}
\author{
Ze Vinicius, Jiaxi Ying, and Daniel Palomar
}
