% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spectra.R
\name{read_spectra}
\alias{read_spectra}
\title{Read files from various formats into `spectra`}
\usage{
read_spectra(
  path,
  format,
  type = "target_reflectance",
  recursive = FALSE,
  exclude_if_matches = NULL,
  ignore_extension = FALSE,
  ...
)
}
\arguments{
\item{path}{Path to directory or input files}

\item{format}{file formats. "asd" (for ASD); "sig" or "svc" (for SVC);
"sed" or "psr" (for SpecEvo PSR).}

\item{type}{Data type to read. "target_reflectance", "target_radiance", or
"reference_radiance". Defaults to "target_reflectance".}

\item{recursive}{read files recursively}

\item{exclude_if_matches}{excludes files that match this regular expression.
Example: "BAD"}

\item{ignore_extension}{boolean. If TRUE, the parser will try to read every
file in path regardless of the expected extension.}

\item{...}{nothing yet}
}
\value{
a single `spectra` or a list of `spectra` (in case files have
        incompatible band number or bands values)
}
\description{
Read files from various formats into `spectra`
}
\examples{
library(spectrolab)
dir_path = system.file("extdata", "Acer_example", package = "spectrolab")

# Relative reflectance is re
spec     = read_spectra(path = dir_path, format = "sig")
}
\author{
Jose Eduardo Meireles
}
