% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_and_setters.R
\name{names<-.spectra}
\alias{names<-.spectra}
\title{Set spectra sample names}
\usage{
\method{names}{spectra}(x) <- value
}
\arguments{
\item{x}{spectra object (lhs)}

\item{value}{values to be assigned (rhs)}
}
\value{
nothing. called for its side effect.
}
\description{
\code{names} assigns sample names to lhs
}
\details{
Sample names must not be coercible to numeric. That is, names such as "1" and
"153.44" are invalid even if they are encoded as character. names will add the
prefix "spec_" to any element of value that is coercible to numeric.
}
\examples{
library(spectrolab)
spec = as.spectra(spec_matrix_example, name_idx = 1)
names(spec) = toupper(names(spec))
}
\author{
Jose Eduardo Meireles
}
