/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.OwnedRectEclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.DefaultInvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.LinePainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class RectGradientPainter
extends BaseTabComponent {
    public static final TabPainter FACTORY = new TabPainter(){

        public TabComponent createTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable) {
            return new RectGradientPainter(eclipseTabPane, dockable);
        }

        public TabPanePainter createDecorationPainter(EclipseTabPane eclipseTabPane) {
            return new LinePainter(eclipseTabPane);
        }

        public InvisibleTab createInvisibleTab(InvisibleTabPane invisibleTabPane, Dockable dockable) {
            return new DefaultInvisibleTab(invisibleTabPane, dockable);
        }

        public Border getFullBorder(BorderedComponent borderedComponent, DockController dockController, Dockable dockable) {
            return new OwnedRectEclipseBorder(borderedComponent, dockController, true);
        }
    };
    private MatteBorder contentBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);

    public RectGradientPainter(EclipseTabPane eclipseTabPane, Dockable dockable) {
        super(eclipseTabPane, dockable);
        this.setLayout(null);
        this.setOpaque(false);
        this.update();
        this.updateBorder();
    }

    public Insets getOverlap(TabComponent tabComponent) {
        return new Insets(0, 0, 0, 0);
    }

    public void updateFocus() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateOrientation() {
        this.update();
    }

    protected void updateSelected() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateColors() {
        this.update();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void update() {
        Insets insets = null;
        Insets insets2 = null;
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                insets = new Insets(3, 5, 3, 2);
                insets2 = new Insets(1, 2, 1, 5);
                break;
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                insets = new Insets(5, 3, 2, 3);
                insets2 = new Insets(2, 1, 5, 1);
            }
        }
        this.getLabel().setForeground(this.getTextColor());
        this.setLabelInsets(insets);
        this.setButtonInsets(insets2);
        this.revalidate();
        this.repaint();
    }

    private Color getTextColor() {
        boolean bl = this.isFocusTemporarilyLost();
        if (this.isFocused() && !bl) {
            return (Color)this.colorStackTabTextSelectedFocused.value();
        }
        if (this.isFocused() && bl) {
            return (Color)this.colorStackTabTextSelectedFocusLost.value();
        }
        if (this.isSelected()) {
            return (Color)this.colorStackTabTextSelected.value();
        }
        return (Color)this.colorStackTabText.value();
    }

    public void updateBorder() {
        int n;
        EclipseTabPane eclipseTabPane;
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean bl = false;
        if (window != null) {
            boolean bl2 = bl = !window.isActive();
        }
        Color color = this.isSelected() ? (this.isFocused() ? (bl ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
        if (!color.equals(this.contentBorder.getMatteColor())) {
            this.contentBorder = new MatteBorder(2, 2, 2, 2, color);
        }
        if ((eclipseTabPane = this.getPane()) != null && (n = this.getDockableIndex()) >= 0) {
            eclipseTabPane.setContentBorderAt(n, this.contentBorder);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Paint paint;
        Color color;
        Color color2;
        super.paintComponent(graphics);
        int n = this.getHeight();
        int n2 = this.getWidth();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = (Color)this.colorStackBorder.value();
        boolean bl = this.isFocusTemporarilyLost();
        TabPlacement tabPlacement = this.getOrientation();
        if (this.isFocused() && !bl) {
            color2 = (Color)this.colorStackTabTopSelectedFocused.value();
            color = (Color)this.colorStackTabBottomSelectedFocused.value();
        } else if (this.isFocused() && bl) {
            color2 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color = (Color)this.colorStackTabBottomSelectedFocusLost.value();
        } else if (this.isSelected()) {
            color2 = (Color)this.colorStackTabTopSelected.value();
            color = (Color)this.colorStackTabBottomSelected.value();
        } else {
            color2 = (Color)this.colorStackTabTop.value();
            color = (Color)this.colorStackTabBottom.value();
        }
        if (tabPlacement == TabPlacement.BOTTOM_OF_DOCKABLE || tabPlacement == TabPlacement.RIGHT_OF_DOCKABLE) {
            paint = color2;
            color2 = color;
            color = paint;
        }
        paint = null;
        if (!color2.equals(color)) {
            paint = tabPlacement.isHorizontal() ? new GradientPaint(0.0f, 0.0f, color2, 0.0f, n, color) : new GradientPaint(0.0f, 0.0f, color2, n2, 0.0f, color);
        }
        boolean bl2 = this.isSelected();
        int n3 = this.getTabIndex();
        graphics2D.setColor(color3);
        Paint paint2 = graphics2D.getPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(color2);
        }
        if (bl2) {
            this.paintSelected(graphics2D, n3, paint2);
        } else {
            switch (tabPlacement) {
                case TOP_OF_DOCKABLE: {
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    graphics.fillRect(0, 1, this.getWidth(), this.getHeight() - 1);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    graphics.fillRect(1, 0, this.getWidth() - 1, this.getHeight());
                }
            }
            graphics2D.setPaint(paint2);
        }
        if (!bl2 && !this.isNextTabSelected()) {
            graphics.setColor(color3);
            switch (tabPlacement) {
                case TOP_OF_DOCKABLE: 
                case BOTTOM_OF_DOCKABLE: {
                    graphics.drawLine(n2 - 1, 0, n2 - 1, n);
                    break;
                }
            }
        }
    }

    private void paintSelected(Graphics2D graphics2D, int n, Paint paint) {
        TabPlacement tabPlacement = this.getOrientation();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        switch (tabPlacement) {
            case TOP_OF_DOCKABLE: {
                graphics2D.fillRect(1, 0, n2 - 2, n3);
                graphics2D.drawLine(0, 1, 0, n3);
                graphics2D.setPaint(paint);
                if (n != 0) {
                    graphics2D.drawLine(1, 0, 1, 0);
                    graphics2D.drawLine(0, 1, 0, n3);
                }
                graphics2D.drawLine(n2 - 2, 0, n2 - 2, 0);
                graphics2D.drawLine(n2 - 1, 1, n2 - 1, n3);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                graphics2D.fillRect(1, 0, n2 - 2, n3);
                graphics2D.drawLine(0, n3 - 2, 0, 0);
                graphics2D.setPaint(paint);
                if (n != 0) {
                    graphics2D.drawLine(1, n3 - 1, 1, n3 - 1);
                    graphics2D.drawLine(0, n3 - 2, 0, 0);
                }
                graphics2D.drawLine(n2 - 2, n3 - 1, n2 - 2, n3 - 1);
                graphics2D.drawLine(n2 - 1, n3 - 2, n2 - 1, 0);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                graphics2D.fillRect(0, 1, n2, n3 - 2);
                graphics2D.drawLine(1, 0, n2, 0);
                graphics2D.setPaint(paint);
                if (n != 0) {
                    graphics2D.drawLine(0, 1, 0, 1);
                    graphics2D.drawLine(1, 0, n2, 0);
                }
                graphics2D.drawLine(0, n3 - 2, 0, n3 - 2);
                graphics2D.drawLine(1, n3 - 1, n2, n3 - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                graphics2D.fillRect(0, 1, n2, n3 - 2);
                graphics2D.drawLine(0, 0, n2 - 1, 0);
                graphics2D.setPaint(paint);
                if (n != 0) {
                    graphics2D.drawLine(n2 - 1, 1, n2 - 1, 1);
                    graphics2D.drawLine(0, 0, n2 - 2, 0);
                }
                graphics2D.drawLine(n2 - 1, n3 - 2, n2 - 1, n3 - 2);
                graphics2D.drawLine(0, n3 - 1, n2 - 2, n3 - 1);
            }
        }
    }
}

