/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.KeyboardController;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;

public class DefaultKeyboardController
extends KeyboardController {
    private AWTEventListener listener = new AWTEventListener(){

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                if (keyEvent.getID() == 401) {
                    DefaultKeyboardController.this.fireKeyPressed(keyEvent);
                } else if (keyEvent.getID() == 402) {
                    DefaultKeyboardController.this.fireKeyReleased(keyEvent);
                } else if (keyEvent.getID() == 400) {
                    DefaultKeyboardController.this.fireKeyTyped(keyEvent);
                }
            }
        }
    };

    public DefaultKeyboardController(DockController dockController) {
        super(dockController);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 8L);
        }
        catch (SecurityException securityException) {
            System.err.println("Can't register AWTEventListener, support for global KeyEvents disabled");
        }
    }

    public void kill() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

