/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationModeAction
extends SimpleButtonAction {
    private LocationMode mode;
    private String iconKey;
    private String defaultIconKey;
    private int count = 0;
    private IconManagerListener iconListener = new IconManagerListener(){

        public void iconChanged(String string, Icon icon) {
            LocationModeAction.this.setIcon(LocationModeAction.this.controller.getIcons().getIcon(LocationModeAction.this.iconKey));
        }
    };
    private PropertyValue<KeyStroke> stroke;
    private DockController controller;

    public LocationModeAction(DockController dockController, LocationMode locationMode, String string, String string2, PropertyKey<KeyStroke> propertyKey) {
        if (locationMode == null) {
            throw new NullPointerException("mode is null");
        }
        if (string == null) {
            throw new NullPointerException("defaultIconKey is null");
        }
        if (string2 == null) {
            throw new NullPointerException("iconKey is null");
        }
        if (propertyKey == null) {
            throw new NullPointerException("gotoStroke is null");
        }
        this.mode = locationMode;
        this.iconKey = string2;
        this.defaultIconKey = string;
        this.stroke = new PropertyValue<KeyStroke>(propertyKey){

            @Override
            protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                LocationModeAction.this.setAccelerator(keyStroke2);
            }
        };
        this.setController(dockController);
    }

    @Override
    public void action(Dockable dockable) {
        super.action(dockable);
        LocationModeManager<?> locationModeManager = this.mode.getManager();
        locationModeManager.apply(dockable, this.mode.getUniqueIdentifier(), false);
    }

    @Override
    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = Resources.getIcon(this.defaultIconKey);
        }
        super.setIcon(icon);
    }

    protected void setController(DockController dockController) {
        if (this.count > 0) {
            this.connect(this.controller, dockController);
        }
        this.controller = dockController;
    }

    private void connect(DockController dockController, DockController dockController2) {
        IconManager iconManager;
        if (dockController != null) {
            iconManager = dockController.getIcons();
            iconManager.remove(this.defaultIconKey, this.iconListener);
            iconManager.remove(this.iconKey, this.iconListener);
            this.setIcon(null);
        }
        this.stroke.setProperties(dockController2);
        if (dockController2 != null) {
            iconManager = dockController2.getIcons();
            iconManager.add(this.defaultIconKey, this.iconListener);
            iconManager.add(this.iconKey, this.iconListener);
            this.setIcon(iconManager.getIcon(this.iconKey));
        }
    }

    protected DockController getController() {
        return this.controller;
    }

    protected boolean checkTrigger(KeyEvent keyEvent) {
        return true;
    }

    @Override
    protected void bound(Dockable dockable) {
        super.bound(dockable);
        if (this.count == 0) {
            this.connect(null, this.controller);
        }
        ++this.count;
    }

    @Override
    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.count;
        if (this.count == 0) {
            this.connect(this.controller, null);
        }
    }
}

