/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.view;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SeparatorAction;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicSeparatorHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.DropDownMiniButton;
import bibliothek.gui.dock.themes.basic.action.dropdown.ButtonDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.dropdown.SelectableDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.dropdown.SubDropDownHandler;
import bibliothek.gui.dock.themes.basic.action.menu.ButtonMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.DropDownMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.SelectableMenuHandler;
import bibliothek.util.container.Tuple;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionViewConverter {
    private Map<Tuple<ActionType<?>, ViewTarget<?>>, Entry<?, ?>> converters = new HashMap();

    public ActionViewConverter() {
        this.putDefault(ActionType.BUTTON, ViewTarget.MENU, new ViewGenerator<ButtonDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                return new ButtonMenuHandler(action, dockable);
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.MENU, new ViewGenerator<SelectableDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return new SelectableMenuHandler(action, dockable, new JCheckBoxMenuItem());
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.MENU, new ViewGenerator<MenuDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                return new MenuMenuHandler(action, dockable);
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.MENU, new ViewGenerator<SelectableDockAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return new SelectableMenuHandler(action, dockable, new JRadioButtonMenuItem());
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.MENU, new ViewGenerator<SeparatorAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
                if (action.shouldDisplay(ViewTarget.MENU)) {
                    return new BasicSeparatorHandler(new JPopupMenu.Separator(), action);
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.MENU, new ViewGenerator<DropDownAction, MenuViewItem<JComponent>>(){

            @Override
            public MenuViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                return new DropDownMenuHandler(action, dockable);
            }
        });
        this.putDefault(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                BasicButtonHandler handler = new BasicButtonHandler(action, dockable);
                BasicMiniButton button = new BasicMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Check handler = new BasicSelectableHandler.Check(action, dockable);
                BasicMiniButton button = new BasicMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                BasicMenuHandler handler = new BasicMenuHandler(action, dockable);
                BasicMiniButton button = new BasicMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Radio handler = new BasicSelectableHandler.Radio(action, dockable);
                BasicMiniButton button = new BasicMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.TITLE, new ViewGenerator<SeparatorAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
                if (action.shouldDisplay(ViewTarget.TITLE)) {
                    return new BasicSeparatorHandler(new JSeparator(), action);
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                BasicDropDownButtonHandler handler = new BasicDropDownButtonHandler(action, dockable);
                DropDownMiniButton button = new DropDownMiniButton(handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        this.putDefault(ActionType.BUTTON, ViewTarget.DROP_DOWN, new ViewGenerator<ButtonDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                return new ButtonDropDownHandler(action, dockable, new JMenuItem());
            }
        });
        this.putDefault(ActionType.CHECK, ViewTarget.DROP_DOWN, new ViewGenerator<SelectableDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return new SelectableDropDownHandler(action, dockable, (JMenuItem)new JCheckBoxMenuItem());
            }
        });
        this.putDefault(ActionType.RADIO, ViewTarget.DROP_DOWN, new ViewGenerator<SelectableDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                return new SelectableDropDownHandler(action, dockable, (JMenuItem)new JRadioButtonMenuItem());
            }
        });
        this.putDefault(ActionType.SEPARATOR, ViewTarget.DROP_DOWN, new ViewGenerator<SeparatorAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, SeparatorAction action, Dockable dockable) {
                if (action.shouldDisplay(ViewTarget.DROP_DOWN)) {
                    return new SubDropDownHandler(new BasicSeparatorHandler(new JPopupMenu.Separator(), action));
                }
                return null;
            }
        });
        this.putDefault(ActionType.DROP_DOWN, ViewTarget.DROP_DOWN, new ViewGenerator<DropDownAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                return new SubDropDownHandler(action.createView(ViewTarget.MENU, converter, dockable));
            }
        });
        this.putDefault(ActionType.MENU, ViewTarget.DROP_DOWN, new ViewGenerator<MenuDockAction, DropDownViewItem>(){

            @Override
            public DropDownViewItem create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                return new SubDropDownHandler(action.createView(ViewTarget.MENU, converter, dockable));
            }
        });
    }

    public <A, D extends DockAction> void putClient(ActionType<D> action, ViewTarget<A> target, ViewGenerator<D, A> generator) {
        if (action == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(action, target);
        entry.clientGenerator = generator;
    }

    public <A, D extends DockAction> void putTheme(ActionType<D> action, ViewTarget<A> target, ViewGenerator<D, A> generator) {
        if (action == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(action, target);
        entry.themeGenerator = generator;
    }

    public <A, D extends DockAction> void putDefault(ActionType<D> action, ViewTarget<A> target, ViewGenerator<D, A> generator) {
        if (action == null) {
            throw new IllegalArgumentException("Action must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null");
        }
        Entry<D, A> entry = this.getEntry(action, target);
        entry.defaultGenerator = generator;
    }

    public <A> A createView(DockAction action, ViewTarget<A> target, Dockable dockable) {
        return action.createView(target, this, dockable);
    }

    public <A, D extends DockAction> A createView(ActionType<D> type, D action, ViewTarget<A> target, Dockable dockable) {
        ViewGenerator<D, A> converter = this.getConverter(type, target);
        if (converter == null) {
            throw new IllegalArgumentException("That combination is not known: " + type + " " + target);
        }
        return converter.create(this, action, dockable);
    }

    protected <A, D extends DockAction> ViewGenerator<D, A> getConverter(ActionType<D> action, ViewTarget<? super A> target) {
        Entry<D, ? super A> entry = this.getEntry(action, target);
        if (entry.clientGenerator != null) {
            return entry.clientGenerator;
        }
        if (entry.themeGenerator != null) {
            return entry.themeGenerator;
        }
        return entry.defaultGenerator;
    }

    private <A, D extends DockAction> Entry<D, A> getEntry(ActionType<D> action, ViewTarget<? super A> target) {
        Entry<Object, Object> result = this.converters.get(new Tuple<ActionType<D>, ViewTarget<? super A>>(action, target));
        if (result == null) {
            result = new Entry();
            this.converters.put(new Tuple<ActionType<D>, ViewTarget<? super A>>(action, target), result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<D extends DockAction, A> {
        public ViewGenerator<D, A> clientGenerator;
        public ViewGenerator<D, A> themeGenerator;
        public ViewGenerator<D, A> defaultGenerator;

        private Entry() {
        }
    }
}

