/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;

public class MediumBoundaryRestriction
implements BoundaryRestriction {
    public Rectangle check(ScreenDockWindow window) {
        Point center = window.getTitleCenter();
        if (center == null) {
            Rectangle target = window.getWindowBounds();
            center = new Point(target.width / 2, target.height / 2);
        }
        return this.validate(window.getWindowBounds(), center, center);
    }

    public Rectangle check(ScreenDockWindow window, Rectangle target) {
        Point search;
        Point center = window.getTitleCenter();
        if (center == null) {
            search = center = new Point(target.width / 2, target.height / 2);
        } else {
            Rectangle bounds = window.getWindowBounds();
            search = new Point(center);
            search.x += target.x - bounds.x;
            search.y += target.y - bounds.y;
        }
        return this.validate(target, center, search);
    }

    protected Rectangle validate(Rectangle target, Point center, Point search) {
        Rectangle screen = this.findDevice(search.x + target.x, search.y + target.y);
        if (screen == null) {
            return null;
        }
        Rectangle original = center.equals(search) ? screen : this.findDevice(center.x + target.x, center.y + target.y);
        if (!original.equals(screen)) {
            center = search;
        }
        Rectangle result = new Rectangle(target);
        result.width = Math.max(100, result.width);
        result.height = Math.max(50, result.height);
        result.x = Math.max(screen.x - center.x, result.x);
        result.y = Math.max(screen.y - center.y, result.y);
        result.x = Math.min(screen.x + screen.width - center.x, result.x);
        result.y = Math.min(screen.y + screen.height - center.y, result.y);
        return result;
    }

    protected Rectangle findDevice(int x, int y) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice best = null;
        int bestDist = 0;
        for (GraphicsDevice device : devices) {
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            int dist = this.dist(bounds.x, bounds.width, x) + this.dist(bounds.y, bounds.height, y);
            if (best != null && dist >= bestDist) continue;
            best = device;
            bestDist = dist;
        }
        if (best == null) {
            return null;
        }
        return best.getDefaultConfiguration().getBounds();
    }

    private int dist(int x, int width, int pos) {
        if (pos < x) {
            return x - pos;
        }
        if (pos > x + width) {
            return pos - x - width;
        }
        return 0;
    }
}

