\name{as.tilename}
\alias{as.character.tilename}
\alias{as.numeric.tilename}
\alias{as.tilename}
\alias{as.tilename.character}
\alias{as.tilename.numeric}
\alias{print.tilename}
\alias{tilename}
\title{Alphanumeric tile names}
\usage{
  as.tilename(x, ...)

  \method{as.tilename}{numeric} (x, ...)

  \method{as.character}{tilename} (x, ...)

  \method{as.numeric}{tilename} (x, ...)

  \method{as.tilename}{character} (x, ...)

  \method{print}{tilename} (x, ...)
}
\arguments{
  \item{x}{object of class \code{tilename},
  \code{character}, or \code{numeric} (of length 2)}

  \item{...}{additional arguments (currently ignored)}
}
\value{
  object of class \code{tilename}, \code{character}, or
  numeric vector of length 2
}
\description{
  Functions for generating and handling alphanumeric tile
  names of the form \code{"X2:Y7"} as used by
  \code{\link{partition.tiles}} and
  \code{\link{represampling.tile.bootstrap}}.
}
\examples{
tnm = as.tilename(c(2,3))
tnm # "X2:Y3"
as.numeric(tnm) # c(2,3)
}
\seealso{
  \code{\link{partition.tiles}},
  \code{\link{represampling}},
  \code{\link{represampling.tile.bootstrap}}
}

