% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample.factor}
\alias{resample.factor}
\title{Draw uniform random (sub)sample at the group level}
\usage{
resample.factor(data, param = list(fac = "class", n = Inf, replace = FALSE))
}
\arguments{
\item{data}{a \code{data.frame}, rows represent samples}

\item{param}{a list with the following components: \code{fac} is a factor
variable of length \code{nrow(data)} or the name of a factor variable
in \code{data}; \code{n} is a numeric value specifying the size of the
subsample (in terms of groups, not observations); \code{replace} determines
if resampling of groups is to be done with or without replacement.}
}
\value{
a \code{data.frame} containing a subset of the rows of \code{data}.
}
\description{
\code{resample.factor} draws a random (sub)sample
(with or without replacement) of the groups or clusters identified by
the \code{fac} argument.
}
\details{
If \code{param$replace=FALSE}, a subsample of
\code{min(param$n,nlevel(data[,fac]))} groups will be drawn from \code{data}.
If \code{param$replace=TRUE}, the number of groups to be drawn is \code{param$n}.
}
\examples{
data(ecuador) # Muenchow et al. (2012), see ?ecuador
d <- resample.uniform(ecuador, param = list(strat = 'slides', n = 200))
nrow(d) # == 200
sum(d$slides == 'TRUE')

}
\seealso{
\code{\link[=resample.strat.uniform]{resample.strat.uniform()}}, \code{\link[=sample]{sample()}}
}
