% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-locations.R
\name{sample_locations}
\alias{sample_locations}
\title{Generic sampling locations function}
\usage{
sample_locations(method, place_id, n_house, shapefile, noise = 0.001,
  shapefile_id = NULL)
}
\arguments{
\item{method}{character vector either "uniform" or "roads" determining 
how we are sampling locations}

\item{place_id}{numeric specifiying the ID of the region we are 
subsampling}

\item{n_house}{numeric indicating the number of households}

\item{shapefile}{sp class with all of the locations for each place id. Note 
that this is a list with two shapefiles if me}

\item{noise}{the standard deviation of how much 
we jitter the road locations in each direction (only if method is "roads")}

\item{shapefile_id}{optionally include a shapefile id for subsetting shapefile}
}
\value{
SpatialPoints object with coordinates for the n households
}
\description{
Generic sampling locations function
}
\examples{
data("tartanville")
example_place_id <- tartanville$pop_table$place_id[1] 
example_puma_id <- tartanville$pop_table$puma_id[1] 
example_n_house <- tartanville$pop_table$n_house[1] 
sample_locations(method = "uniform", 
                  shapefile = tartanville$shapefile, 
                  n_house = example_n_house, 
                  place_id = example_place_id)
                  
}
