% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-spherical-spline.R
\name{Cartesian_to_Spherical}
\alias{Cartesian_to_Spherical}
\title{Convert Cartesian coordinates to cpherical coordinates}
\usage{
Cartesian_to_Spherical(x)
}
\arguments{
\item{x}{A matrix where each row represents a point in Cartesian coordinates.}
}
\value{
A matrix where each row represents a point in spherical coordinates.
}
\description{
This function converts Cartesian coordinates to spherical coordinates.
}
\details{
The Cartesian coordinates (x, y, z) are converted to spherical coordinates (theta, phi).
Theta represents the inclination angle (0 to pi), and phi represents the azimuth angle (0 to 2*pi).
}
\examples{
#example1
cartesian_points1 <- matrix(c(1/sqrt(3), 1/sqrt(3), 1/sqrt(3),-1/sqrt(3), 1/sqrt(3), -1/sqrt(3)),
  ncol = 3, byrow = TRUE)
Cartesian_to_Spherical(cartesian_points1)
#example2
cartesian_points2 <- matrix(c(1, 0, 0, 0, 1, 0, 0, 0, 1),ncol = 3, byrow = TRUE)
Cartesian_to_Spherical(cartesian_points2)
}
