% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/sph_distr.R
\name{p_sph_stat_Bingham}
\alias{p_sph_stat_Bingham}
\alias{d_sph_stat_Bingham}
\alias{p_sph_stat_CJ12}
\alias{d_sph_stat_CJ12}
\alias{p_sph_stat_Rayleigh}
\alias{d_sph_stat_Rayleigh}
\alias{p_sph_stat_Rayleigh_HD}
\alias{d_sph_stat_Rayleigh_HD}
\alias{sph_stat_distr}
\alias{p_sph_stat_Ajne}
\alias{d_sph_stat_Ajne}
\alias{p_sph_stat_Bakshaev}
\alias{d_sph_stat_Bakshaev}
\alias{p_sph_stat_Gine_Fn}
\alias{d_sph_stat_Gine_Fn}
\alias{p_sph_stat_Gine_Gn}
\alias{d_sph_stat_Gine_Gn}
\alias{p_sph_stat_PAD}
\alias{d_sph_stat_PAD}
\alias{p_sph_stat_PCvM}
\alias{d_sph_stat_PCvM}
\alias{p_sph_stat_PRt}
\alias{d_sph_stat_PRt}
\alias{p_sph_stat_Riesz}
\alias{d_sph_stat_Riesz}
\alias{p_sph_stat_Sobolev}
\alias{d_sph_stat_Sobolev}
\title{Asymptotic distributions for spherical uniformity statistics}
\usage{
p_sph_stat_Bingham(x, p)

d_sph_stat_Bingham(x, p)

p_sph_stat_CJ12(x, regime = 1L, beta = 0)

d_sph_stat_CJ12(x, regime = 3L, beta = 0)

p_sph_stat_Rayleigh(x, p)

d_sph_stat_Rayleigh(x, p)

p_sph_stat_Rayleigh_HD(x, p)

d_sph_stat_Rayleigh_HD(x, p)

p_sph_stat_Ajne(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_Ajne(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_Bakshaev(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_Bakshaev(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_Gine_Fn(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_Gine_Fn(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_Gine_Gn(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_Gine_Gn(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_PAD(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_PAD(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_PCvM(x, p, K_max = 1000, thre = 0, ...)

d_sph_stat_PCvM(x, p, K_max = 1000, thre = 0, ...)

p_sph_stat_PRt(x, p, t = 1/3, K_max = 1000, thre = 0, ...)

d_sph_stat_PRt(x, p, t = 1/3, K_max = 1000, thre = 0, ...)

p_sph_stat_Riesz(x, p, s = 1, K_max = 1000, thre = 0, ...)

d_sph_stat_Riesz(x, p, s = 1, K_max = 1000, thre = 0, ...)

p_sph_stat_Sobolev(x, p, vk2 = c(0, 0, 1), K_max = 1000, thre = 0, ...)

d_sph_stat_Sobolev(x, p, vk2 = c(0, 0, 1), ...)
}
\arguments{
\item{x}{a vector of size \code{nx} or a matrix of size \code{c(nx, 1)}.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{regime}{type of asymptotic regime for the CJ12 test, either \code{1}
(sub-exponential regime), \code{2} (exponential), or \code{3}
(super-exponential; default).}

\item{beta}{\eqn{\beta} parameter in the exponential regime of the CJ12
test, a non-negative real. Defaults to \code{0}.}

\item{K_max}{integer giving the truncation of the series that compute the
asymptotic p-value of a Sobolev test. Defaults to \code{1e3}.}

\item{thre}{error threshold for the tail probability given by the
the first terms of the truncated series of a Sobolev test. Defaults to
\code{0} (no further truncation).}

\item{...}{further parameters passed to \code{\link{p_Sobolev}} or
\code{\link{d_Sobolev}} (such as \code{x_tail}).}

\item{t}{\eqn{t} parameter for the Rothman and Cressie tests, a real in
\eqn{(0, 1)}. Defaults to \code{1 / 3}.}

\item{s}{\eqn{s} parameter for the \eqn{s}-Riesz test, a real in
\eqn{(0, 2)}. Defaults to \code{1}.}

\item{vk2}{weights for the finite Sobolev test. A non-negative vector or
matrix. Defaults to \code{c(0, 0, 1)}.}
}
\value{
\itemize{
  \item \code{r_sph_stat_*}: a matrix of size \code{c(n, 1)} containing
  the sample.
  \item \code{p_sph_stat_*}, \code{d_sph_stat_*}: a matrix of size
  \code{c(nx, 1)} with the evaluation of the distribution or density
  functions at \code{x}.
}
}
\description{
Computation of the asymptotic null distributions of
spherical uniformity statistics.
}
\details{
Descriptions and references on most of the asymptotic distributions
are available in García-Portugués and Verdebout (2018).
}
\examples{
# Ajne
curve(d_sph_stat_Ajne(x, p = 3, method = "HBE"), n = 2e2, ylim = c(0, 4))
curve(p_sph_stat_Ajne(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# Bakshaev
curve(d_sph_stat_Bakshaev(x, p = 3, method = "HBE"), to = 5, n = 2e2,
      ylim = c(0, 2))
curve(p_sph_stat_Bakshaev(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# Bingham
curve(d_sph_stat_Bingham(x, p = 3), to = 20, n = 2e2, ylim = c(0, 1))
curve(p_sph_stat_Bingham(x, p = 3), n = 2e2, col = 2, add = TRUE)

# CJ12
curve(d_sph_stat_CJ12(x, regime = 1), from = -10, to = 10, n = 2e2,
      ylim = c(0, 1))
curve(d_sph_stat_CJ12(x, regime = 2, beta = 0.1), n = 2e2, col = 2,
      add = TRUE)
curve(d_sph_stat_CJ12(x, regime = 3), n = 2e2, col = 3, add = TRUE)
curve(p_sph_stat_CJ12(x, regime = 1), n = 2e2, col = 1, add = TRUE)
curve(p_sph_stat_CJ12(x, regime = 2, beta = 0.1), n = 2e2, col = 2,
      add = TRUE)
curve(p_sph_stat_CJ12(x, regime = 3), col = 3, add = TRUE)

# Gine Fn
curve(d_sph_stat_Gine_Fn(x, p = 3, method = "HBE"), to = 2, n = 2e2,
      ylim = c(0, 2))
curve(p_sph_stat_Gine_Fn(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# Gine Gn
curve(d_sph_stat_Gine_Gn(x, p = 3, method = "HBE"), to = 1.5, n = 2e2,
      ylim = c(0, 2.5))
curve(p_sph_stat_Gine_Gn(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# PAD
curve(d_sph_stat_PAD(x, p = 3, method = "HBE"), to = 3, n = 2e2,
      ylim = c(0, 1.5))
curve(p_sph_stat_PAD(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# PCvM
curve(d_sph_stat_PCvM(x, p = 3, method = "HBE"), to = 0.6, n = 2e2,
      ylim = c(0, 7))
curve(p_sph_stat_PCvM(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# PRt
curve(d_sph_stat_PRt(x, p = 3, method = "HBE"), n = 2e2, ylim = c(0, 5))
curve(p_sph_stat_PRt(x, p = 3, method = "HBE"), n = 2e2, col = 2, add = TRUE)

# Rayleigh
curve(d_sph_stat_Rayleigh(x, p = 3), to = 15, n = 2e2, ylim = c(0, 1))
curve(p_sph_stat_Rayleigh(x, p = 3), n = 2e2, col = 2, add = TRUE)

# HD-standardized Rayleigh
curve(d_sph_stat_Rayleigh_HD(x, p = 3), from = -4, to = 4, n = 2e2,
      ylim = c(0, 1))
curve(p_sph_stat_Rayleigh_HD(x, p = 3), n = 2e2, col = 2, add = TRUE)

# Riesz
curve(d_sph_stat_Riesz(x, p = 3, method = "HBE"), n = 2e2, from = 0, to = 5,
      ylim = c(0, 2))
curve(p_sph_stat_Riesz(x, p = 3, method = "HBE"), n = 2e2, col = 2,
      add = TRUE)

# Sobolev
x <- seq(-1, 5, by = 0.05)
vk2 <- diag(rep(0.3, 2))
matplot(x, d_sph_stat_Sobolev(x = x, vk2 = vk2, p = 3), type = "l",
        ylim = c(0, 1), lty = 1)
matlines(x, p_sph_stat_Sobolev(x = x, vk2 = vk2, p = 3), lty = 1)
matlines(x, d_sph_stat_Sobolev(x = x, vk2 = vk2 + 0.01, p = 3), lty = 2)
matlines(x, p_sph_stat_Sobolev(x = x, vk2 = vk2 + 0.01, p = 3), lty = 2)
}
