% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sm}
\alias{sm}
\title{Generate a reparameterized P-spline base}
\usage{
sm(x, K = min(length(unique(x)), 20), spline.degree = 3, diff.ord = 2,
  rankZ = 0.999, centerBase = T, centerx = x, decomposition = c("ortho",
  "MM", "asIs"), tol = 1e-10)
}
\arguments{
\item{x}{covariate}

\item{K}{number of basis functions in the original basis (defaults to 20)}

\item{spline.degree}{defaults to 3 for cubic B-plines}

\item{diff.ord}{order of the difference penalty, defaults to 2 for penalizing deviations from linearity}

\item{rankZ}{how many eigenvectors to retain from the eigen decomposition: either a number > 3 or the proportion of
the sum of eigenvalues the retained eigenvectors must represent at least. Defaults to .999.}

\item{centerBase}{project the basis of the penalized part into the complement of the column space of the
basis of the unpenalized part? defaults to TRUE}

\item{centerx}{vector of x-values used for centering (defaults to \code{x})}

\item{decomposition}{use a truncated spectral decomposition of the implied prior covariance of \eqn{f(x)} for a low rank representation
   with orthogonal
   basis functions and i.i.d. coefficients (\code{"ortho"}), or use the mixed model reparameterization for
non-orthogonal basis functions
and i.i.d. coefficients (\code{"MM"}) or use basis functions as they are with i.i.d. coefficients
   (\code{"asIs"}). Defaults to \code{"ortho"}.}

\item{tol}{count eigenvalues smaller than this as zero}
}
\value{
a basis for a smooth function in x
}
\description{
The returned matrix is a low-rank approximation of the original P-spline basis (unless \code{decomposition = "asIs"}),
that is projected into the complement of the nullspace of the associated penalty (unless \code{centerBase = FALSE}),
i.e. for the default second order difference penalty, the resulting basis cannot reproduce linear or constant functions and
parameterizes the "wiggly" part of the influence of \code{x} only.
This means that it very rarely makes sense to run a model with \code{sm(x)} without also using \code{\link{lin}(x)}
or \code{\link{u}(x)}. The projection improves the separability between
the linear and smooth parts of the influence of \code{x} and centers the resulting function estimates s.t \eqn{\sum_i f(x_i) = 0}.
}
\author{
Fabian Scheipl
}
\references{
Kneib, T. (2006). Mixed model based inference in structured additive regression.
  Dr. Hut. \url{http://edoc.ub.uni-muenchen.de/archive/00005011/}
}

