% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEE.R
\name{GEE}
\alias{GEE}
\title{GEE (Generalized Estimating Equations)}
\usage{
GEE(formula, family, data, coord, corstr = "fixed", cluster = 3,
  moran.params = list(), plot = FALSE, scale.fix = FALSE)
}
\arguments{
\item{formula}{Model formula. Variable names must match variables in \code{data}.}

\item{family}{\code{gaussian}, \code{binomial}, or \code{poisson} are supported. Called using
a quoted character string (i.e. \code{family} = "gaussian").}

\item{data}{A data frame with variable names that match the variables specified in \code{formula}.}

\item{coord}{A matrix of two columns with corresponding cartesian
coordinates. Currently only supports integer coordinates.}

\item{corstr}{Expected autocorrelation structure: \code{independence}, \code{fixed},
\code{exchangeable}, and \code{quadratic}  are possible.

 \itemize{
   \item\code{independence} - This is the same as a GLM, i.e. correlation matrix = identity matrix.

   \item\code{fixed} - Uses an adapted isotropic power function specifying all correlation
   coefficients.

   \item\code{exchangeable} and \code{quadratic} for clustering, i.e.
   the correlation matrix has a block diagonal form:

   \itemize{
      \item\code{exchangeable} - All intra-block correlation coefficients are equal.

      \item\code{quadratic} - Intra-block correlation coefficients for different
         distances can be different.
         }
       }}

\item{cluster}{Cluster size for cluster models \code{exchangeable}
 and \code{quadratic}. Values of 2, 3, and 4 are allowed.
 \itemize{
   \item 2 - a 2*2 cluster

   \item 3 - a 3*3 cluster

   \item 4 - a 4*4 cluster
}}

\item{moran.params}{A list of parameters for calculating Moran's I.
\itemize{
  \item\code{lim1} Lower limit for first bin. Default is 0.
  \item\code{increment} Step size for calculating I. Default is 1.
}}

\item{plot}{A logical value indicating whether autocorrelation of
residuals should be plotted.}

\item{scale.fix}{A logical indicating whether or not the scale parameter should
be fixed. The default is \code{FALSE}. Use \code{TRUE} when planning to use
stepwise model selection procedures in \code{step.spind}.}
}
\value{
An object of class \code{GEE}. This consists of a list with the
following elements:
\describe{
      \item{\code{call}}{Call}
      \item{\code{formula}}{Model formula}
      \item{\code{family}}{Family}
      \item{\code{coord}}{Coordinates used for the model}
      \item{\code{corstr}}{User-selected correlation structure}
      \item{\code{b}}{Estimate of regression parameters}
      \item{\code{s.e.}}{Standard errors of the estimates}
      \item{\code{z}}{Depending on the \code{family}, either a \emph{z} or \emph{t} value}
      \item{\code{p}}{\emph{p}-values for each parameter estimate}
      \item{\code{scale}}{Scale parameter (dispersion parameter) of the distribution's variance}
      \item{\code{scale.fix}}{Logical indicating whether \code{scale} has fixed value}
      \item{\code{cluster}}{User-specified cluster size for clustered models}
      \item{\code{fitted}}{Fitted values from the model}
      \item{\code{resid}}{Normalized Pearson residuals}
      \item{\code{w.ac}}{Working autocorrelation parameters}
      \item{\code{Mat.ac}}{Working autocorrelation matrix}
      \item{\code{QIC}}{Quasi Information Criterion. See \code{\link{qic.calc}}
       for further details}
      \item{\code{QLik}}{Quasi-likelihood. See \code{\link{qic.calc}}
       for further details}
      \item{\code{plot}}{Logical value indicating whether autocorrelation should
      be plotted}
      \item{\code{moran.params}}{Parameters for calculating Moran's I}
      \item{\code{v2}}{Parameter variance of the \code{GEE} model}
      \item{\code{var.naive}}{Paramter variance of the \code{independence} model}
      \item{\code{ac.glm}}{Autocorrelation of GLM residuals}
      \item{\code{ac.gee}}{Autocorrelation of GEE residuals}
}

Elements can be viewed using the \code{\link{summary.GEE}} methods included in
the package.
}
\description{
\code{GEE} provides GEE-based methods from the packages \pkg{gee} and \pkg{geepack}
to account for spatial autocorrelation in multiple linear regressions
}
\details{
GEE can be used to fit linear models for response variables with
different distributions: \code{gaussian}, \code{binomial}, or \code{poisson}.
As a spatial model, it is a generalized linear model in which the residuals
may be autocorrelated. It accounts for spatial (2-dimensional)
autocorrelation of the residuals in cases of regular gridded datasets
and returns corrected parameter estimates. The grid cells are assumed to be square.
}
\note{
When using \code{corstr = "fixed"} on large data sets, the function
may return an error, as the resulting variance-covariance matrix is too
large for R to handle. If this happens, one will have to use one of the
cluster models (i.e \code{quadratic, exchangeable}).
}
\examples{
data(musdata)
coords<- musdata[,4:5]

mgee<-GEE(musculus ~ pollution + exposure, "poisson", musdata,
      coord=coords, corstr="fixed", plot=TRUE,scale.fix=FALSE)

summary(mgee,printAutoCorPars=TRUE)

}
\references{
Carl G & Kuehn I, 2007. Analyzing Spatial Autocorrelation in Species
Distributions using Gaussian and Logit Models, Ecol. Model. 207, 159 - 170

Carey, V. J., 2006. Ported to R by Thomas Lumley (versions 3.13,
4.4, version 4.13)., B. R. gee: Generalized Estimation Equation
solver. R package version 4.13-11.

Yan, J., 2004. geepack: Generalized Estimating Equation Package.
R package version 0.2.10.
}
\seealso{
\code{\link{qic.calc}}, \code{\link{summary.GEE}}, \code{\link[gee]{gee}}
}
\author{
Gudrun Carl, Sam Levin
}
