% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/th_indep.R
\name{th.indep}
\alias{th.indep}
\title{Spatial threshold-independent accuracy measures}
\usage{
th.indep(data, coord, spatial = TRUE, plot.ROC = TRUE,
  customize_plot = NULL)
}
\arguments{
\item{data}{A data frame or matrix with two columns. The first column
should contain actual presence/absence data (binary, 0 or 1) and the
second column should contain model predictions of probability of
occurence (numeric, between 0 and 1).}

\item{coord}{A data frame or matrix with two columns containing x,y
coordinates for each actual and predicted value. Coordinates must be
integer and consecutively numbered.}

\item{spatial}{A logical value indicating whether spatial corrected
indices (rather than classical indices) should be computed}

\item{plot.ROC}{A logical indicating whether the ROC should be plotted}

\item{customize_plot}{Additional plotting parameters passed to \code{ggplot}}
}
\value{
A list with the following components:
\describe{
 \item{\code{AUC}}{Area under curve}
 \item{\code{opt.thresh}}{optimal threshold for maximum TSS value}
 \item{\code{TSS}}{Maximum TSS value}
 \item{\code{sensitivity}}{Sensitivity}
 \item{\code{Specificity}}{Specificity}
}
}
\description{
Calculates spatially corrected, threshold-independent metrics for
an observational data set and model predictions (AUC, ROC, max-TSS)
}
\examples{
data(hook)
data <- hook[ ,1:2]
coord <- hook[ ,3:4]
si2 <- th.indep(data, coord, spatial = TRUE)
si2$AUC
si2$TSS
si2$opt.thresh

}
\references{
Carl G, Kuehn I (2017) Spind: a package for computing spatially
 corrected accuracy measures. Ecography 40: 675-682.
 doi: 10.1111/ecog.02593
}
\seealso{
\code{\link{th.dep}}
}
\author{
Gudrun Carl
}
