% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEE.R
\name{qic.calc}
\alias{qic.calc}
\title{Quasi-Information Criterion for Generalized Estimating
Equations}
\usage{
qic.calc(formula, family, data, mu, var.robust, var.indep.naive)
}
\arguments{
\item{formula}{a model formula}

\item{family}{\code{gaussian}, \code{binomial}, or \code{poisson}}

\item{data}{a data frame}

\item{mu}{fitted values from a model}

\item{var.robust}{variance of model parameters}

\item{var.indep.naive}{naive variance of model parameters under the
\code{independence} model}
}
\value{
A list with the following components:
 \describe{
   \item{\code{QIC}}{quasi-information criterion}
   \item{\code{loglik}}{quasi-likelihood}
 }
}
\description{
A function for calculating quasi-likelihood and Quasi-Information
Criterion values based on the method of Hardin & Hilbe (2003).
}
\references{
Hardin, J.W. & Hilbe, J.M. (2003) Generalized Estimating Equations. Chapman and Hall, New York.

Barnett et al. Methods in Ecology & Evolution 2010, 1, 15-24.
}
