% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{ggtour}
\alias{ggtour}
\title{Prepare a new grammar of graphics tour}
\usage{
ggtour(basis_array, data = NULL, angle = 0.05, facet_by = NULL)
}
\arguments{
\item{basis_array}{An array of projection bases for the tour, as produced
with \code{manual_tour()} or \code{tour::save_history()}, or a single basis.}

\item{data}{Numeric data to project. If left NULL, will check if it data is
stored as an attribute of the the \code{basis_array}.}

\item{angle}{Target angle (in radians) for interpolation for
\code{tour::save_history()} generated \code{basis_array}. Defaults to .05.}

\item{facet_by}{Optionally, add a vector to facet the ggtour on. Similar to
adding \code{facet_grid(rows = facet_by)} to the tour.}
}
\description{
\code{ggtour()} initializes a ggplot object for a tour. \verb{proto_*} functions are
added to the tour, analogous to \verb{ggplot() + geom_*}. The final tour object is
then animated with \code{animate_plotly()} or \code{animate_ggtour()}, or passed to
\code{filmstrip()} for static plot faceting on frames.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species
bas <- basis_pca(dat)
mv <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

## Returns headless ggplot(), but required for proto_* functions.
ggtour(mt_path, dat, angle = .15)

## d = 2 case
ggt <- ggtour(mt_path, dat) +
  proto_basis() +
  proto_point(list(color = clas, shape = clas),
              list(size = 1.5))
\dontrun{
animate_plotly(ggt)}

## d = 1 case
bas1d <- basis_pca(dat, d = 1)
mt_path1d <- manual_tour(basis = bas1d, manip_var = mv)
ggt1d <- ggtour(mt_path1d, dat, angle = .2) +
  proto_default1d(list(fill = clas))
\dontrun{
animate_plotly(ggt1d)}

## d = 2, with facet
ggt <- ggtour(mt_path, dat, facet_by = clas) +
  proto_default(list(color = clas, shape = clas), list(size = 1.5))
\dontrun{
animate_plotly(ggt)}

## d = 1, with facet
ggt1d <- ggtour(mt_path1d, dat, facet_by = clas) +
  proto_default1d(list(color = clas, shape = clas, fill = clas))
## faceted 1d doesn't work the best with plotly; esp rug, and basis segments.
\dontrun{
animate_gganimate(ggt1d)}
}
\seealso{
Other ggtour proto: 
\code{\link{filmstrip}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto}
